% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_list_nest}
\alias{data_dict_list_nest}
\title{Bind listed data dictionaries}
\usage{
data_dict_list_nest(data_dict_list, name_group = NULL)
}
\arguments{
\item{data_dict_list}{A list of tibble(s) representing meta data to be
transformed.}

\item{name_group}{A character string of one column in the dataset that can be
taken as a grouping column.}
}
\value{
A list of tibble(s) identifying a workable data dictionary structure.
}
\description{
Binds a list of data dictionaries into one data dictionary.
This is a wrapper function analogous to \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package
# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.

data_dict_list <- DEMO_files[
    c('dd_MELBOURNE_1_format_maelstrom',
      'dd_MELBOURNE_2_format_maelstrom')]
 
data_dict_list_nest(data_dict_list,name_group = "table")

}

}
\seealso{
\code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
}
