% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-data_summarise.R
\name{summary_variables_date}
\alias{summary_variables_date}
\title{Provide descriptive statistics for variables of type 'date' in a dataset}
\usage{
summary_variables_date(
  dataset = NULL,
  data_dict = NULL,
  dataset_preprocess = .dataset_preprocess,
  .dataset_preprocess = NULL
)
}
\arguments{
\item{dataset}{A dataset object.}

\item{data_dict}{A list of data frame(s) representing metadata of the input
dataset. Automatically generated if not provided.}

\item{dataset_preprocess}{A data frame which provides summary of the
variables (for internal processes and programming).}

\item{.dataset_preprocess}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A data frame providing statistical description of 'date' variables present
in a dataset.
}
\description{
Summarizes (in a data frame) the columns of type 'date' in a dataset and its
data dictionary (if any). The summary provides information about quality,
type, composition, and descriptive statistics of variables. Statistics are
generated by valueType.
}
\details{
A data dictionary contains the list of variables in a dataset and metadata
about the variables and can be associated with a dataset. A data dictionary
object is a list of data frame(s) named 'Variables' (required) and
'Categories' (if any). To be usable in any function, the data frame
'Variables' must contain at least the \code{name} column, with all unique and
non-missing entries, and the data frame 'Categories' must contain at least
the \code{variable} and \code{name} columns, with unique combination of
\code{variable} and \code{name}.

A dataset is a data table containing variables. A dataset object is a
data frame and can be associated with a data dictionary. If no
data dictionary is provided with a dataset, a minimum workable
data dictionary will be generated as needed within relevant functions.
Identifier variable(s) for indexing can be specified by the user.
The id values must be non-missing and will be used in functions that
require it. If no identifier variable is specified, indexing is
handled automatically by the function.
}
\examples{
{
   
# use madshapR_DEMO provided by the package
library(dplyr)
library(fabR)

dataset_preprocess <- 
  madshapR_DEMO$dataset_TOKYO \%>\%
    mutate(dob = as_any_date(dob)) \%>\%
    select(dob) \%>\%
    head() \%>\%
    dataset_preprocess

glimpse(summary_variables_date(dataset_preprocess = dataset_preprocess))

}

}
