% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_schedule.R
\name{run_schedule}
\alias{run_schedule}
\title{Run a schedule}
\usage{
run_schedule(
  schedule,
  orch_frequency = "1 day",
  check_datetime = lubridate::now(tzone = "UTC"),
  resources = list(),
  run_all = FALSE,
  n_show_next = 5,
  cores = 1,
  logging = FALSE,
  log_file = NULL,
  log_file_max_bytes = 1e+06,
  quiet = FALSE
)
}
\arguments{
\item{schedule}{a table of scheduled pipelines generated from \code{build_schedule()}}

\item{orch_frequency}{of the orchestrator, a single string formatted like "1 day", "2 weeks", "hourly", etc.}

\item{check_datetime}{datetime against which to check the running of pipelines (default is current system time in UTC)}

\item{resources}{named list of shared resources made available to pipelines as needed}

\item{run_all}{run all pipelines regardless of the schedule (default is \code{FALSE}) - useful for testing.
Does not apply to pipes with a \code{maestroSkip} tag.}

\item{n_show_next}{show the next n scheduled pipes}

\item{cores}{number of cpu cores to run if running in parallel. If > 1, \code{furrr} is used and
a multisession plan must be executed in the orchestrator (see details)}

\item{logging}{whether or not to write the logs to a file (default = \code{FALSE})}

\item{log_file}{path to the log file (ignored if \code{logging == FALSE})}

\item{log_file_max_bytes}{numeric specifying the maximum number of bytes allowed in the log file before purging the log (within a margin of error)}

\item{quiet}{silence metrics to the console (default = \code{FALSE})}
}
\value{
list with named elements \code{status} and \code{artifacts}
}
\description{
Given a schedule in a \code{maestro} project, runs the pipelines that are scheduled to execute
based on the current time.
}
\details{
\subsection{Pipeline schedule logic}{

The function \code{run_schedule()} examines each pipeline in the schedule table and determines
whether it is scheduled to run at the current time using some simple time arithmetic. We assume
\code{run_schedule(schedule, check_datetime = Sys.time())}, but this need not be the case.
}

\subsection{Output}{

\code{run_schedule()} returns a list with two elements: \code{status} and \code{artifacts}. Status is a data.frame where
each row is a pipeline and the columns are information about the pipeline status, execution time, etc. Artifacts
are any values returned from pipelines.
}

\subsection{Pipelines with arguments (resources)}{

If a pipeline takes an argument that doesn't include a default value, these can be supplied
in the orchestrator via \code{run_schedule(resources = list(arg1 = val))}. The name of the argument
used by the pipeline must match the name of the argument in the list. Currently, each named
resource must refer to a single object. In other words, you can't have two pipes using
the same argument but requiring different values.
}

\subsection{Running in parallel}{

Pipelines can be run in parallel using the \code{cores} argument. First, you must run \code{future::plan(future::multisession)}
in the orchestrator. Then, supply the desired number of cores to the \code{cores} argument. Note that
console output appears different in multicore mode.
}
}
\examples{

# Runs the schedule every 1 day
run_schedule(
  example_schedule,
  orch_frequency = "1 day",
  quiet = TRUE
)

# Runs the schedule every 15 minutes
run_schedule(
  example_schedule,
  orch_frequency = "15 minutes",
  quiet = TRUE
)
}
