% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.SpatRaster.R
\name{as.SpatRaster}
\alias{as.SpatRaster}
\title{as.SpatRaster}
\usage{
as.SpatRaster(x, res = NULL)
}
\arguments{
\item{x}{MAgPIE object}

\item{res}{spatial data resolution. If not provided it will be guessed.}
}
\value{
A SpatRaster object
}
\description{
Convert magclass object to a SpatRaster object. Requires the terra package.
}
\examples{

if (requireNamespace("terra", quietly = TRUE)) {
   r <- terra::rast(ncols = 360, nrows = 180, nl = 4)
   r[85:89, 176:179] <- (1:20 \%*\% t(1:4))
   r[15:19, 76:79] <-   (10 + 1:20 \%*\% t(1:4))
   names(r) <- c("y2000..bla", "y2001..bla", "y2000..blub", "y2001..blub")
   m <- as.magpie(r)
   r2 <- as.SpatRaster(m)
}
}
\seealso{
\code{\link{getCoords}}
}
\author{
Jan Philipp Dietrich
}
