% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defines.R
\name{defines}
\alias{defines}
\alias{image_set_defines}
\title{Set encoder defines}
\usage{
image_set_defines(image, defines)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{defines}{a named character vector with extra options to control reading.
These are the \verb{-define key\{=value\}} settings in the \href{http://www.imagemagick.org/script/command-line-options.php#define}{command line tool}.
Use an empty string for value-less defines, and NA to unset a define.}
}
\description{
So called 'defines' are properties that are passed along to external
filters and libraries. Usually defines are used in \link{image_read} or
\link{image_write} to control the image encoder/decoder, but you can also
set these manually on the image object.
}
\details{
The defines values must be a character string, where the names contain
the defines keys. Each name must be of the format "enc:key" where the
first part is the encoder or filter to which the key is passed. For
example \code{"png:...."} defines can control the encoding and decoding of
png images.

The \link{image_set_defines} function does not make a copy of the image, so
the defined values remain in the image object until they are overwritten
or unset.
}
\examples{
# Write an image
x <- image_read("https://jeroen.github.io/images/frink.png")
image_write(x, "frink.png")

# Pass some properties to PNG encoder
defines <- c("png:compression-filter" = "1", "png:compression-level" = "0")
image_set_defines(x, defines)
image_write(x, "frink-uncompressed.png")

# Unset properties
defines[1:2] = NA
image_set_defines(x, defines)
image_write(x, "frink-final.png")

# Compare size and cleanup
file.info(c("frink.png", "frink-uncompressed.png", "frink-final.png"))
unlink(c("frink.png", "frink-uncompressed.png", "frink-final.png"))
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{animation}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
