% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePaletteCLARA.R
\name{makePaletteCLARA}
\alias{makePaletteCLARA}
\title{Make your color palette with the CLARA algorithm}
\usage{
makePaletteCLARA(photo, n = 4)
}
\arguments{
\item{photo}{Image location path. It can also be a URL address.}

\item{n}{Number of elements to be generated in the color palette. The default value is 4.}
}
\value{
A palette of colors
}
\description{
Creates a color palette from an image, using the CLARA (Clustering Large Applications) algorithm
}
\examples{
makePaletteCLARA(system.file("extdata", "picture02.jpg", package="makePalette"))
makePaletteCLARA(system.file("extdata", "picture04.png", package="makePalette"), 6)
makePaletteCLARA(system.file("extdata", "picture05.jpg", package="makePalette"), 10)
MyPalette = makePaletteCLARA(system.file("extdata", "picture05.jpg", package="makePalette"), 10)
barplot(1:10, col=MyPalette)

}
