% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pipeline.R
\name{pipeline-vis}
\alias{pipeline-vis}
\alias{show_pipeline}
\alias{save_pipeline}
\title{Visualise the Pipeline.}
\usage{
show_pipeline(
  pipeline = get_pipeline(),
  as = c("nomnoml", "visnetwork", "text"),
  labels = NULL,
  notes = NULL,
  ...
)

save_pipeline(
  file,
  pipeline = get_pipeline(),
  as = c("nomnoml", "visnetwork", "text"),
  labels = NULL,
  notes = NULL,
  ...
)
}
\arguments{
\item{pipeline}{A pipeline. See \link{Pipeline} for more details.}

\item{as}{A string determining whether to use \code{nomnoml} or \code{visNetwork}}

\item{labels}{A named character vector mapping nodes in the \code{pipeline} onto
labels to display beside them.}

\item{notes}{A named character vector mapping nodes in the \code{Pipeline} onto
notes to display on beside the labels (nomnoml) or as tooltips (visNetwork).}

\item{...}{Arguments passed onto \code{Pipeline$nomnoml()} or \code{Pipeline$visnetwork}}

\item{file}{File to save png (nomnoml) or html (visnetwork) into}
}
\description{
Produce a flowchart visualisation of the pipeline. Out-of-date targets will
be coloured red, up-to-date targets will be coloured green, and everything
else will be blue.
}
\details{
Labels and notes must be supplied as named character vector where the
names correspond to the filepaths of nodes (i.e. \code{targets}, \code{dependencies},
or \code{source} scripts)
}
\examples{
\dontrun{
# Run pipeline
make_with_source(
  "recode.R",
  "data/0 raw_data.R",
  "data/1 data.R"
)
make_with_source(
  "merge.R",
  c("data/1 data.R", "data/0 raw_pop.R"),
  "data/2 data.R"
)

# Visualise pipeline with custom notes
show_pipeline(notes = c(
  "data/0 raw_data.R" = "Raw survey data",
  "data/0 raw_pop.R" = "Raw population data",
  "data/1 data.R" = "Survey data with recodes applied",
  "data/2 data.R" = "Survey data with demographic variables merged in"
))
}
}
\seealso{
Other pipeline: 
\code{\link{Pipeline}},
\code{\link{pipeline-accessors}}
}
\concept{pipeline}
