% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.sf.R
\name{autoplot.sf}
\alias{autoplot.sf}
\title{Create a basic plot to visualise downloaded shapefiles}
\usage{
\method{autoplot}{sf}(object, ..., map_title = NULL, facet = FALSE, printed = TRUE)
}
\arguments{
\item{object}{A sf object downloaded using /code{/link{getShp}}.}

\item{...}{Other arguments passed to specific methods}

\item{map_title}{Custom title used for the plot.}

\item{facet}{If TRUE, splits map into a separate facet for each administrative level.}

\item{printed}{Should the plot print to graphics device.}
}
\value{
\code{autoplot.sf} returns a map of the supplied sf object
}
\description{
\code{autoplot.sf} creates a map of shapefiles downloaded using getShp.
}
\examples{
\donttest{
MDG_shp <- getShp(ISO = "MDG", admin_level = "admin0")
autoplot(MDG_shp)
}

}
