% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractRaster.R
\name{extractRaster}
\alias{extractRaster}
\title{Extract pixel values from MAP rasters using point coordinates.}
\usage{
extractRaster(
  df,
  csv_path = NULL,
  surface = NULL,
  year = NULL,
  dataset_id = NULL
)
}
\arguments{
\item{df}{data.frame containing coordinates of input point locations, must contain columns named 'latitude'/'lat'/'x'  AND 'longitude'/'long'/'y')}

\item{csv_path}{(optional) user-specified path to which extractRaster coordinates and results are stored.}

\item{surface}{deprecated argument. Please remove it from your code.}

\item{year}{for time-varying rasters: if downloading a single surface for one or more years, \code{year} should be a vector specifying the desired year(s). if downloading more than one surface, use a list the same length as \code{surface}, providing the desired year-range for each time-varying surface in \code{surface} or \code{NA} for static rasters.}

\item{dataset_id}{A character string specifying the dataset ID(s) of one or more rasters. These dataset ids can be found in the data.frame returned by listRaster, in the dataset_id column e.g. c('Malaria__202206_Global_Pf_Mortality_Count', 'Malaria__202206_Global_Pf_Parasite_Rate')}
}
\value{
\code{extractRaster} returns the input dataframe (\code{df}), with the following columns appended, providing values for each raster, location and year.

\enumerate{
\item \code{layerName} dataset id corresponding to extracted raster values for a given row, check \code{\link{listRaster}} for raster metadata.
\item \code{year} the year for which raster values were extracted (time-varying rasters only; static rasters do not have this column).
\item \code{value} the raster value for the pixel in which a given point location falls.
}
}
\description{
\code{extractRaster} extracts pixel values from MAP rasters at user-specified point locations (without downloading the entire raster).
}
\examples{
#Download PfPR data for Nigeria and Cameroon and map the locations of these points using autoplot
\dontrun{
# Get some data and remove rows with NAs in location or examined or positive columns.
NGA_CMR_PR <- getPR(country = c("Nigeria", "Cameroon"), species = "Pf")
complete <- complete.cases(NGA_CMR_PR[, c(4, 5, 16, 17)])
NGA_CMR_PR <- NGA_CMR_PR[complete, ]

# Extract PfPR data at those locations.
data <- extractRaster(df = NGA_CMR_PR[, c('latitude', 'longitude')],
                      dataset_id = 'Malaria__202206_Global_Pf_Parasite_Rate',
                      year=2020)

# Some rasters are stored with NA encoded as -9999
data$value[data$value == -9999] <- NA

# We can quickly plot a summary
plot((NGA_CMR_PR$positive / NGA_CMR_PR$examined) ~ data$value)
}


}
\seealso{
\code{autoplot} method for quick mapping of PR point locations (\code{\link{autoplot.pr.points}}).
}
