/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import salvo.jesus.util.Collections;
import salvo.jesus.util.HeapNode;
import salvo.jesus.util.HeapNodeComparator;

public class Heap
implements Serializable {
    List binarytree = new ArrayList(10);
    HeapNodeComparator comparator;

    public Heap() {
        this.comparator = new HeapNodeComparator(-1);
    }

    public Heap(HeapNodeComparator comparator) {
        this.comparator = comparator;
    }

    public void insert(HeapNode node) {
        int preinsertsize = this.binarytree.size();
        this.binarytree.add(node);
        this.upHeap(preinsertsize);
    }

    public HeapNode remove() {
        HeapNode topnode = (HeapNode)this.binarytree.get(0);
        HeapNode endnode = (HeapNode)this.binarytree.get(this.binarytree.size() - 1);
        this.binarytree.set(0, endnode);
        this.binarytree.remove(this.binarytree.size() - 1);
        if (this.binarytree.size() > 0) {
            this.downHeap(0);
        }
        return topnode;
    }

    public void setPriority(HeapNode node, double priority) {
        if (this.binarytree.contains(node)) {
            node.setPriority(priority);
            int index = this.binarytree.indexOf(node);
            index = this.upHeap(index);
            this.downHeap(index);
        }
    }

    public void clear() {
        this.binarytree.clear();
    }

    public boolean isEmpty() {
        return this.binarytree.isEmpty();
    }

    public HeapNode contains(Object object, Comparator heapnodeobjectcomparator) {
        return (HeapNode)Collections.contains(this.binarytree, object, heapnodeobjectcomparator);
    }

    private int upHeap(int index) {
        HeapNode current = (HeapNode)this.binarytree.get(index);
        while (index != 0) {
            HeapNode parent;
            int parentindex = index / 2;
            if (index % 2 == 0) {
                --parentindex;
            }
            if (this.comparator.compare(current, parent = (HeapNode)this.binarytree.get(parentindex)) <= 0) break;
            this.binarytree.set(index, parent);
            index = parentindex;
            if (index > 0) continue;
        }
        this.binarytree.set(index, current);
        return index;
    }

    private int downHeap(int index) {
        HeapNode current = (HeapNode)this.binarytree.get(index);
        int treesize = this.binarytree.size();
        while (treesize > 1) {
            int higherprioritychildindex;
            HeapNode higherprioritychild;
            int leftchildindex = index * 2 + 1;
            int rightchildindex = index * 2 + 2;
            HeapNode leftchild = leftchildindex >= treesize ? null : (HeapNode)this.binarytree.get(leftchildindex);
            HeapNode rightchild = rightchildindex >= treesize ? null : (HeapNode)this.binarytree.get(rightchildindex);
            if (leftchild == null && rightchild == null || this.comparator.compare(current, higherprioritychild = (HeapNode)this.binarytree.get(higherprioritychildindex = leftchild != null && rightchild == null ? leftchildindex : (this.comparator.compare(leftchild, rightchild) < 0 ? rightchildindex : leftchildindex))) >= 0) break;
            this.binarytree.set(index, higherprioritychild);
            index = higherprioritychildindex;
            if (index < treesize - 1) continue;
        }
        this.binarytree.set(index, current);
        return index;
    }

    public String toString() {
        return this.binarytree.toString();
    }
}

