/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.constraints.ge;

import cc.mallet.classify.constraints.ge.MaxEntFLGEConstraints;
import cc.mallet.types.MatrixOps;
import cc.mallet.util.Maths;

public class MaxEntKLFLGEConstraints
extends MaxEntFLGEConstraints {
    public MaxEntKLFLGEConstraints(int numFeatures, int numLabels, boolean useValues) {
        super(numFeatures, numLabels, useValues);
    }

    @Override
    public double getValue() {
        double value = 0.0;
        for (int fi : this.constraints.keys()) {
            MaxEntFLGEConstraints.MaxEntFLGEConstraint constraint = (MaxEntFLGEConstraints.MaxEntFLGEConstraint)this.constraints.get(fi);
            if (!(constraint.count > 0.0)) continue;
            double constraintValue = 0.0;
            for (int labelIndex = 0; labelIndex < this.numLabels; ++labelIndex) {
                if (!(constraint.target[labelIndex] > 0.0)) continue;
                if (constraint.expectation[labelIndex] == 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                constraintValue += constraint.target[labelIndex] * (Math.log(constraint.expectation[labelIndex] / constraint.count) - Math.log(constraint.target[labelIndex]));
            }
            assert (!Double.isNaN(constraintValue) && !Double.isInfinite(constraintValue));
            value += constraintValue * constraint.weight;
        }
        return value;
    }

    @Override
    public void addConstraint(int fi, double[] ex, double weight) {
        assert (Maths.almostEquals(MatrixOps.sum(ex), 1.0));
        this.constraints.put(fi, (Object)new MaxEntKLFLGEConstraint(ex, weight));
    }

    protected class MaxEntKLFLGEConstraint
    extends MaxEntFLGEConstraints.MaxEntFLGEConstraint {
        public MaxEntKLFLGEConstraint(double[] target, double weight) {
            super(target, weight);
        }

        @Override
        public double getValue(int li) {
            assert (this.count != 0.0);
            if (this.target[li] == 0.0 && this.expectation[li] == 0.0) {
                return 0.0;
            }
            return this.weight * (this.target[li] / this.expectation[li]);
        }
    }
}

