/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.util;

import cc.mallet.optimize.Optimizable;
import cc.mallet.util.MalletLogger;
import java.util.logging.Logger;

public class CachingOptimizable {

    public static abstract class ByBatchGradient
    extends Base
    implements Optimizable.ByBatchGradient {
        private int lastIndex;
        private int[] lastAssns;

        @Override
        public void getBatchValueGradient(double[] buffer, int batchIndex, int[] batchAssignments) {
            if (buffer.length != this.getNumParameters()) {
                throw new IllegalArgumentException("Argument is not of the  correct dimensions");
            }
            if (batchIndex != this.lastIndex || batchAssignments != this.lastAssns) {
                this.forceStale();
                this.lastIndex = batchIndex;
                this.lastAssns = batchAssignments;
            }
            if (this.cachedValueStale) {
                this.cachedValue = this.computeBatchValue(batchIndex, batchAssignments);
                this.cachedValueStale = false;
            }
            if (this.cachedGradientStale) {
                if (this.cachedGradient == null) {
                    this.cachedGradient = new double[this.getNumParameters()];
                }
                this.computeBatchGradient(this.cachedGradient, batchIndex, batchAssignments);
                this.cachedGradientStale = false;
            }
            System.arraycopy(this.cachedGradient, 0, buffer, 0, this.cachedGradient.length);
        }

        @Override
        public double getBatchValue(int batchIndex, int[] batchAssignments) {
            if (batchIndex != this.lastIndex || batchAssignments != this.lastAssns) {
                this.forceStale();
                this.lastIndex = batchIndex;
                this.lastAssns = batchAssignments;
            }
            if (this.cachedValueStale) {
                this.cachedValue = this.computeBatchValue(batchIndex, batchAssignments);
                logger.info("computeValue() = " + this.cachedValue);
                this.cachedValueStale = false;
            }
            return this.cachedValue;
        }

        protected abstract double computeBatchValue(int var1, int[] var2);

        protected abstract void computeBatchGradient(double[] var1, int var2, int[] var3);
    }

    public static abstract class ByGradient
    extends Base
    implements Optimizable.ByGradientValue {
        protected abstract double computeValue();

        protected abstract void computeValueGradient(double[] var1);

        @Override
        public void getValueGradient(double[] buffer) {
            if (buffer.length != this.getNumParameters()) {
                throw new IllegalArgumentException("Argument is not of the  correct dimensions");
            }
            if (this.cachedValueStale) {
                this.cachedValue = this.computeValue();
                this.cachedValueStale = false;
            }
            if (this.cachedGradientStale) {
                if (this.cachedGradient == null) {
                    this.cachedGradient = new double[this.getNumParameters()];
                }
                this.computeValueGradient(this.cachedGradient);
                this.cachedGradientStale = false;
            }
            System.arraycopy(this.cachedGradient, 0, buffer, 0, this.cachedGradient.length);
        }

        @Override
        public double getValue() {
            if (this.cachedValueStale) {
                long startTime = System.currentTimeMillis();
                this.cachedValue = this.computeValue();
                long endTime = System.currentTimeMillis();
                logger.info("Optimizable computeValue time (ms) =" + (endTime - startTime));
                logger.info("computeValue() = " + this.cachedValue);
                this.cachedValueStale = false;
            }
            return this.cachedValue;
        }

        protected void setCachedGradient(double[] gradient) {
            if (this.cachedGradient == null) {
                this.cachedGradient = new double[this.getNumParameters()];
            }
            System.arraycopy(gradient, 0, this.cachedGradient, 0, gradient.length);
            this.cachedGradientStale = false;
        }
    }

    private static abstract class Base
    implements Optimizable {
        static final Logger logger = MalletLogger.getLogger(CachingOptimizable.class.getName());
        double cachedValue = -1.23456789E8;
        double[] cachedGradient;
        protected boolean cachedValueStale = true;
        protected boolean cachedGradientStale = true;

        private Base() {
        }

        protected abstract void setParametersInternal(double[] var1);

        @Override
        public void setParameters(double[] params) {
            if (params.length != this.getNumParameters()) {
                throw new IllegalArgumentException("Argument is not of the  correct dimensions");
            }
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
            this.setParametersInternal(params);
        }

        @Override
        public void setParameter(int index, double value) {
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
            double[] params = new double[this.getNumParameters()];
            this.getParameters(params);
            params[index] = value;
            this.setParametersInternal(params);
        }

        @Override
        public double getParameter(int index) {
            double[] params = new double[this.getNumParameters()];
            this.getParameters(params);
            return params[index];
        }

        public void forceStale() {
            this.cachedGradientStale = true;
            this.cachedValueStale = true;
        }
    }
}

