% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{breast_cancer_clean_features}
\alias{breast_cancer_clean_features}
\title{Wisconsin Breast Cancer Database}
\format{
A list containing a training and test dataset. These come from a data frame 
with 699 observations on 11 variables, however the ID and class columns have been removed. 
There is a train to test ratio of 0.8. 
\describe{ 
   \item{\code{Cl.thickness}}{Clump Thickness}
   \item{\code{Cell.size}}{Uniformity of Cell Size}
   \item{\code{Cell.shape}}{Uniformity of Cell Shape}
   \item{\code{Marg.adhesion}}{Marginal Adhesion}
   \item{\code{Epith.c.size}}{Single Epithelial Cell Size}
   \item{\code{Bare.nuclei}}{Bare Nuclei}
   \item{\code{Bl.cromatin}}{Bland Chromatin}
   \item{\code{Normal.nucleoli}}{Normal Nucleoli}
   \item{\code{Mitoses}}{Mitoses}
 }
}
\source{
\itemize{ \item Creator: Dr. WIlliam H. Wolberg (physician);
University of Wisconsin Hospital ;Madison; Wisconsin; USA 
          \item Donor: Olvi
Mangasarian (mangasarian@cs.wisc.edu) 
          \item Received: David W. Aha
(aha@cs.jhu.edu) } These data have been taken from the UCI Repository Of
Machine Learning Databases at 
\itemize{ \item
\url{ftp://ftp.ics.uci.edu/pub/machine-learning-databases} 
          \item
\url{http://www.ics.uci.edu/~mlearn/MLRepository.html} 
 } and were converted
to R format by Evgenia Dimitriadou.
}
\usage{
breast_cancer_clean_features
}
\description{
Wisconsin Breast Cancer Database
}
\references{
1. Wolberg,W.H., \& Mangasarian,O.L. (1990). Multisurface method
of pattern separation for medical diagnosis applied to breast cytology. In
Proceedings of the National Academy of Sciences, 87, 9193-9196.\cr - Size of
data set: only 369 instances (at that point in time)\cr - Collected
classification results: 1 trial only\cr - Two pairs of parallel hyperplanes
were found to be consistent with 50\% of the data\cr - Accuracy on remaining
50\% of dataset: 93.5\%\cr - Three pairs of parallel hyperplanes were found
to be consistent with 67\% of data\cr - Accuracy on remaining 33\% of
dataset: 95.9\%

2. Zhang,J. (1992). Selecting typical instances in instance-based learning.
In Proceedings of the Ninth International Machine Learning Conference (pp.
470-479).  Aberdeen, Scotland: Morgan Kaufmann.\cr - Size of data set: only
369 instances (at that point in time)\cr - Applied 4 instance-based learning
algorithms\cr - Collected classification results averaged over 10 trials\cr
- Best accuracy result: \cr - 1-nearest neighbor: 93.7\%\cr - trained on 200
instances, tested on the other 169\cr - Also of interest:\cr - Using only
typical instances: 92.2\% (storing only 23.1 instances)\cr - trained on 200
instances, tested on the other 169

Newman, D.J. & Hettich, S. & Blake, C.L. & Merz, C.J. (1998).  UCI
Repository of machine learning databases
[http://www.ics.uci.edu/~mlearn/MLRepository.html]. Irvine, CA: University
of California, Department of Information and Computer Science.
}
\keyword{datasets}
