% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EuManifold.R, R/General.R, R/HSManifold.R,
%   R/SOManifold.R, R/SPDManifolds.R, R/SphereManifold.R
\name{rieLog.Euclidean}
\alias{rieLog.Euclidean}
\alias{rieLog}
\alias{rieLog.L2}
\alias{rieLog.HS}
\alias{rieLog.Dens}
\alias{rieLog.SO}
\alias{rieLog.LogEu}
\alias{rieLog.AffInv}
\alias{rieLog.Sphere}
\title{Riemannian logarithm map}
\usage{
\method{rieLog}{Euclidean}(mfd, p, X, ...)

rieLog(mfd, p, X, ...)

\method{rieLog}{L2}(mfd, p, X, ...)

\method{rieLog}{HS}(mfd, p, X, tol = 1e-07, ...)

\method{rieLog}{Dens}(mfd, p, X, ...)

\method{rieLog}{SO}(mfd, p, X, tol = 1e-10, ...)

\method{rieLog}{LogEu}(mfd, p, X, ...)

\method{rieLog}{AffInv}(mfd, p, X, ...)

\method{rieLog}{Sphere}(mfd, p, X, tol = 1e-10, ...)
}
\arguments{
\item{mfd}{A manifold object created by \code{\link{createM}}}

\item{p, X}{Matrices with n columns. The logarithm map of each column in X is calculated w.r.t. the corresponding column in p.}

\item{...}{Passed into specific methods}

\item{tol}{Tolerance for `rieLog.SO`}
}
\value{
A matrix in which columns correspond to points on the tangent spaces
}
\description{
Riemannian logarithm map
}
\section{Methods (by class)}{
\itemize{
\item \code{rieLog(Euclidean)}: Method

\item \code{rieLog(L2)}: Method

\item \code{rieLog(HS)}: Method

\item \code{rieLog(Dens)}: Method

\item \code{rieLog(SO)}: Method

\item \code{rieLog(LogEu)}: Method

\item \code{rieLog(AffInv)}: Method

\item \code{rieLog(Sphere)}: Method

}}
