% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowdiff.R
\name{rowdiff}
\alias{rowdiff}
\title{Get row differences between values}
\usage{
rowdiff(df, direction = "forward", exclude = NULL, na.rm = FALSE,
  na_action = NULL)
}
\arguments{
\item{df}{The data set for which differences are required}

\item{direction}{One of forward and reverse. The default is forward meaning the differences
are calculated
in such a way that the difference
between the current value and the next is returned}

\item{exclude}{What data types should be removed?! Currently only supports the entry
"non_numeric." See examples below}

\item{na.rm}{Logical. Should misisng values be removed? Defaults to FALSE.}

\item{na_action}{If na.rm is TRUE, how should missing values be replaced? Uses arguments
to ?na_replace.}
}
\value{
A data.frame object of row differences
}
\description{
This function returns the differences between rows depending on the user's choice.
}
\examples{
rowdiff(iris,exclude = "non_numeric",direction = "reverse")
rowdiff(mtcars)
}
