% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model.R
\name{modeleR}
\alias{modeleR}
\title{Perform several kinds of models in one function}
\usage{
modeleR(df, yname, xname, modeltype, na.rm = FALSE, new_data, ...)
}
\arguments{
\item{df}{The data for which analysis is required}

\item{yname}{The dependent variable}

\item{xname}{The independent variable. Supports formulae x1+x2+...}

\item{modeltype}{Currently one of lm, glm and aov. Other models may work with inaccuracies}

\item{na.rm}{Logical. Should missing values be removed from analysis?}

\item{new_data}{A data.frame object for which new predictions are to be made}

\item{...}{Additional arguments to the modeltype}
}
\value{
A list containing summary stats and a data.frame object of some stats.
}
\description{
Perform several kinds of models in one function
}
\details{
This function provides a friendly way to perform any kind of model in one line.
The model uses the inbuilt R functions aov and lm to make the predictions. If the target
is missing in the new data frame, the function will(currently) make an empty column and
fill this with predictions.
}
\references{
Chambers, J. M. (1992) Linear models. Chapter 4 of Statistical Models in S eds J. M. Chambers and T. J. Hastie, Wadsworth & Brooks/Cole.

Wilkinson, G. N. and Rogers, C. E. (1973). Symbolic descriptions of factorial models for analysis of variance. Applied
Statistics, 22, 392-399. doi: 10.2307/2346786.
}
