% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan2lm_list.R
\name{coef.lm_from_lavaan}
\alias{coef.lm_from_lavaan}
\title{Coefficients of an
'lm_from_lavaan'-Class Object}
\usage{
\method{coef}{lm_from_lavaan}(object, ...)
}
\arguments{
\item{object}{A
'lm_from_lavaan'-class object.}

\item{...}{Additional arguments.
Ignored.}
}
\value{
A numeric vector of the path
coefficients.
}
\description{
Returns the path
coefficients of the terms in an
\code{lm_from_lavaan}-class object.
}
\details{
An \code{lm_from_lavaan}-class
object converts a regression model
for a variable in a \code{lavaan}-class
object to a \code{formula}-class object.
This function simply extracts the
path coefficients estimates.
Intercept is always included, and set
to zero if mean structure is not in
the source \code{lavaan}-class object.

This is an advanced helper used by
\code{\link[=plot.cond_indirect_effects]{plot.cond_indirect_effects()}}.
Exported for advanced users and
developers.
}
\examples{
library(lavaan)
data(data_med)
mod <-
"
m ~ a * x + c1 + c2
y ~ b * m + x + c1 + c2
"
fit <- sem(mod, data_med, fixed.x = FALSE)
fit_list <- lm_from_lavaan_list(fit)
coef(fit_list$m)
coef(fit_list$y)

}
\seealso{
\code{\link[=lm_from_lavaan_list]{lm_from_lavaan_list()}}
}
