% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_delta_med.R
\name{confint.delta_med}
\alias{confint.delta_med}
\title{Confidence Interval for
Delta_Med in a 'xxx'-Class Object}
\usage{
\method{confint}{delta_med}(object, parm, level = NULL, ...)
}
\arguments{
\item{object}{The output of
\code{\link[=delta_med]{delta_med()}}.}

\item{parm}{Not used because only
one parameter, the Delta_Med, is
allowed.}

\item{level}{The level of confidence,
default is \code{NULL} and the level used
when the object was created will be
used.}

\item{...}{Optional arguments.
Ignored.}
}
\value{
A one-row matrix of the confidence
interval. All values are \code{NA} if
bootstrap confidence interval was
not requested when calling
\code{\link[=delta_med]{delta_med()}}.
}
\description{
Return the confidence
interval of the Delta_Med in the
output of \code{\link[=delta_med]{delta_med()}}.
}
\details{
It returns the nonparametric
bootstrap
percentile confidence interval of
Delta_Med, proposed byLiu, Yuan, and
Li (2023). The object must be the
output of \code{\link[=delta_med]{delta_med()}}, with
bootstrap confidence interval
requested when calling \code{\link[=delta_med]{delta_med()}}.
However, the level of confidence
can be different from that used when
call \code{\link[=delta_med]{delta_med()}}.
}
\examples{

library(lavaan)
dat <- data_med
mod <-
"
m ~ x
y ~ m + x
"
fit <- sem(mod, dat)

# Call do_boot() to generate
# bootstrap estimates
# Use 2000 or even 5000 for R in real studies
# Set parallel to TRUE in real studies for faster bootstrapping
boot_out <- do_boot(fit,
                    R = 45,
                    seed = 879,
                    parallel = FALSE,
                    progress = FALSE)
# Remove 'progress = FALSE' in practice
dm_boot <- delta_med(x = "x",
                     y = "y",
                     m = "m",
                     fit = fit,
                     boot_out = boot_out,
                     progress = FALSE)
dm_boot
confint(dm_boot)

}
\seealso{
\code{\link[=delta_med]{delta_med()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
