% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_lawfirm}
\alias{ison_lawfirm}
\title{One-mode lawfirm (Lazega 2001)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A undirected network with 36 nodes and 115 ties
#> # A tibble: 36 x 8
#>   Seniority Status  Gender Office   Years   Age Practice   School      
#>       <int> <chr>   <chr>  <chr>    <int> <int> <chr>      <chr>       
#> 1         1 Partner Man    Boston      31    64 Litigation Harvard/Yale
#> 2         2 Partner Man    Boston      32    62 Corporate  Harvard/Yale
#> 3         3 Partner Man    Hartford    13    67 Litigation Harvard/Yale
#> 4         4 Partner Man    Boston      31    59 Corporate  Other       
#> 5         5 Partner Man    Hartford    31    59 Litigation Connecticut 
#> 6         6 Partner Man    Hartford    29    55 Litigation Harvard/Yale
#> # i 30 more rows
#> # A tibble: 115 x 2
#>    from    to
#>   <int> <int>
#> 1     1    17
#> 2     2     7
#> 3     2    16
#> 4     2    17
#> 5     2    22
#> 6     2    26
#> # i 109 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(ison_lawfirm)
}
\description{
One-mode network dataset collected by Lazega (2001)
on the relations between partners in a corporate law firm called SG&R in New England 1988-1991.
This particular subset includes the 36 partners among the 71 attorneys of this firm.
Nodal attributes include seniority, formal status, office in which they work, gender, lawschool they attended,
their age, and how many years they had been at the firm.
}
\details{
The larger data from which this subset comes includes also individual performance measurements (hours worked, fees brought in)
and attitudes concerning various management policy options (see also \code{{sand}}),
their strong-coworker network, advice network, friendship network, and indirect control network.
}
\references{
Lazega, Emmanuel. 2001.
\emph{The Collegial Phenomenon: The Social Mechanisms of Cooperation Among Peers in a Corporate Law Partnership}.
Oxford: Oxford University Press.
}
\keyword{datasets}
