% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_starwars}
\alias{ison_starwars}
\title{Seven one-mode Star Wars character interactions (Gabasova 2016)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> $`Episode I`
#> # A labelled, weighted, undirected network with 38 nodes and 135 ties
#> # A tibble: 38 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red               33 none  Naboo    
#> 2 QUI-G~    193    89 brown      fair       blue              92 male  <NA>     
#> 3 NUTE ~    191    90 none       mottled g~ red               NA male  Cato Nei~
#> 4 PK-4       NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 5 TC-14      NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 6 OBI-W~    182    77 auburn, w~ fair       blue-gray         57 male  Stewjon  
#> # i 32 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 135 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1    16     11
#> 2     1     2     14
#> 3     1    19     16
#> 4     1    18      3
#> 5     1    23      2
#> 6     1    25      2
#> # i 129 more rows
#> 
#> $`Episode II`
#> # A labelled, weighted, undirected network with 33 nodes and 101 ties
#> # A tibble: 33 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red               33 none  Naboo    
#> 2 CAPTA~    185    85 black      dark       brown             NA male  Naboo    
#> 3 EMPER~    170    75 grey       pale       yellow            82 male  Naboo    
#> 4 SENAT~     NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 5 ORN F~     NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 6 MACE ~    188    84 none       dark       brown             72 male  Haruun K~
#> # i 27 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 101 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1    13      7
#> 2     1    12      7
#> 3     1    24      3
#> 4     3     4      2
#> 5     3     5      2
#> 6     4     5      1
#> # i 95 more rows
#> 
#> $`Episode III`
#> # A labelled, weighted, undirected network with 24 nodes and 65 ties
#> # A tibble: 24 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red             33   none  Naboo    
#> 2 ANAKIN    188    84 blond      fair       blue            41.9 male  Tatooine 
#> 3 OBI-W~    182    77 auburn, w~ fair       blue-gray       57   male  Stewjon  
#> 4 ODD B~     NA    NA <NA>       <NA>       <NA>            NA   <NA>  <NA>     
#> 5 GENER~    216   159 none       brown, wh~ green, y~       NA   male  Kalee    
#> 6 EMPER~    170    75 grey       pale       yellow          82   male  Naboo    
#> # i 18 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 65 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1     6      2
#> 2     1     3     12
#> 3     1     2      9
#> 4     1     9      5
#> 5     1     8      4
#> 6     1    10      4
#> # i 59 more rows
#> 
#> $`Episode IV`
#> # A labelled, weighted, undirected network with 21 nodes and 60 ties
#> # A tibble: 21 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red             33   none  Naboo    
#> 2 CHEWB~    228   112 brown      unknown    blue           200   male  Kashyyyk 
#> 3 C-3PO     167    75 <NA>       gold       yellow         112   none  Tatooine 
#> 4 LUKE      172    77 blond      fair       blue            19   male  Tatooine 
#> 5 DARTH~    202   136 none       white      yellow          41.9 male  Tatooine 
#> 6 CAMIE      NA    NA <NA>       <NA>       <NA>            NA   <NA>  <NA>     
#> # i 15 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 60 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1     2      3
#> 2     1     3     17
#> 3     1     9      1
#> 4     1     4     14
#> 5     1    10      1
#> 6     1    11      4
#> # i 54 more rows
#> 
#> $`Episode V`
#> # A labelled, weighted, undirected network with 21 nodes and 55 ties
#> # A tibble: 21 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red               33 none  Naboo    
#> 2 CHEWB~    228   112 brown      unknown    blue             200 male  Kashyyyk 
#> 3 LUKE      172    77 blond      fair       blue              19 male  Tatooine 
#> 4 HAN       180    80 brown      fair       brown             29 male  Corellia 
#> 5 RIEEK~     NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 6 LEIA      150    49 brown      light      brown             19 fema~ Alderaan 
#> # i 15 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 55 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1     2      5
#> 2     1     7     10
#> 3     1     3      7
#> 4     1     4      4
#> 5     1     6      5
#> 6     1    21      1
#> # i 49 more rows
#> 
#> $`Episode VI`
#> # A labelled, weighted, undirected network with 20 nodes and 55 ties
#> # A tibble: 20 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 R2-D2      96    32 <NA>       white, bl~ red             33   none  Naboo    
#> 2 CHEWB~    228   112 brown      unknown    blue           200   male  Kashyyyk 
#> 3 JERJE~     NA    NA <NA>       <NA>       <NA>            NA   <NA>  <NA>     
#> 4 DARTH~    202   136 none       white      yellow          41.9 male  Tatooine 
#> 5 C-3PO     167    75 <NA>       gold       yellow         112   none  Tatooine 
#> 6 BIB F~    180    NA none       pale       pink            NA   male  Ryloth   
#> # i 14 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 55 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     1     2      8
#> 2     1     5     14
#> 3     1    12      2
#> 4     1     7      2
#> 5     1     8      8
#> 6     1    10      9
#> # i 49 more rows
#> 
#> $`Episode VII`
#> # A labelled, weighted, undirected network with 27 nodes and 92 ties
#> # A tibble: 27 x 10
#>   name   height  mass hair_color skin_color eye_color birth_year sex   homeworld
#>   <chr>   <int> <dbl> <chr>      <chr>      <chr>          <dbl> <chr> <chr>    
#> 1 LUKE      172    77 blond      fair       blue              19 male  Tatooine 
#> 2 R2-D2      96    32 <NA>       white, bl~ red               33 none  Naboo    
#> 3 CHEWB~    228   112 brown      unknown    blue             200 male  Kashyyyk 
#> 4 BB-8       NA    NA none       none       black             NA none  <NA>     
#> 5 LOR S~     NA    NA <NA>       <NA>       <NA>              NA <NA>  <NA>     
#> 6 POE        NA    NA brown      light      brown             NA male  <NA>     
#> # i 21 more rows
#> # i 1 more variable: species <chr>
#> # A tibble: 92 x 3
#>    from    to weight
#>   <int> <int>  <int>
#> 1     2     3      1
#> 2     2     4      2
#> 3     3     4      9
#> 4     2    18      2
#> 5     3     9     20
#> 6     3    11     13
#> # i 86 more rows
}\if{html}{\out{</div>}}
}
\usage{
data(ison_starwars)
}
\description{
One-mode network dataset collected by Gabasova (2016)
on the interactions between Star Wars characters in each movie from
Episode 1 (The Phantom Menace) to Episode 7 (The Force Awakens).
There is a separate network for each episode,
and the data is listed in order from episode 1 to 7.
The network for each episode varies in the number of nodes and ties.
For all networks, characters are named (eg. R2-D2, Anakin, Chewbacca)
and the following node attributes are provided where available:
height, mass, hair color, skin color, eye color, birth year, sex, homeworld, and species.
Weighted ties represent the number of times characters speak
within the same scene of the film.
}
\details{
The network for each episode may be extracted and used separately,
eg. \code{ison_starwars[[1]]} or \verb{ison_starwars$Episode I} for Episode 1.
}
\references{
Gabasova, E. (2016).
\emph{Star Wars social network.}.
\doi{10.5281/zenodo.1411479}
}
\keyword{datasets}
