% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_reformed.R
\name{to_paths}
\alias{to_paths}
\alias{to_matching}
\alias{to_mentoring}
\alias{to_eulerian}
\alias{to_tree}
\title{Modifying networks paths}
\usage{
to_matching(.data, mark = "type")

to_mentoring(.data, elites = 0.1)

to_eulerian(.data)

to_tree(.data)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{mark}{A logical vector marking two types or modes.
By default "type".}

\item{elites}{The proportion of nodes to be selected as mentors.
By default this is set at 0.1.
This means that the top 10\% of nodes in terms of degree,
or those equal to the highest rank degree in the network,
whichever is the higher, will be used to select the mentors.

Note that if nodes are equidistant from two mentors,
they will choose one at random.
If a node is without a path to a mentor,
for example because they are an isolate,
a tie to themselves (a loop) will be created instead.
Note that this is a different default behaviour than that
described in Valente and Davis (1999).}
}
\value{
All \code{to_} functions return an object of the same class as that provided.
So passing it an igraph object will return an igraph object
and passing it a network object will return a network object,
with certain modifications as outlined for each function.
}
\description{
These functions return tidygraphs containing only special sets of ties:
\itemize{
\item \code{to_matching()} returns only the matching ties in some network data.
\item \code{to_mentoring()} returns only ties to nodes' closest mentors.
\item \code{to_eulerian()} returns only the Eulerian path within some network data.
\item \code{to_tree()} returns the spanning tree in some network data or,
if the data is unconnected, a forest of spanning trees.
}
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrrrr}{
    \tab data.frame \tab igraph \tab matrix \tab network \tab tbl_graph \cr
   to_eulerian \tab 0 \tab 1 \tab 0 \tab 0 \tab 1 \cr
   to_matching \tab 1 \tab 1 \tab 1 \tab 1 \tab 1 \cr
   to_mentoring \tab 0 \tab 1 \tab 0 \tab 0 \tab 1 \cr
}
}
\section{\code{to_matching()}}{

\code{to_matching()} uses \code{{igraph}}'s \code{max_bipartite_match()}
to return a network in which each node is only tied to
one of its previous ties.
The number of these ties left is its \emph{cardinality},
and the algorithm seeks to maximise this such that,
where possible, each node will be associated with just one
node in the other mode or some other mark.
The algorithm used is the push-relabel algorithm
with greedy initialization and a global relabelling
after every \eqn{\frac{n}{2}} steps,
where \eqn{n} is the number of nodes in the network.
}

\examples{
to_matching(ison_southern_women)
#autographr(to_matching(ison_southern_women))
autographr(to_mentoring(ison_adolescents))
  to_eulerian(delete_nodes(ison_koenigsberg, "Lomse"))
  #autographr(to_eulerian(delete_nodes(ison_koenigsberg, "Lomse")))
}
\references{
Goldberg, A V; Tarjan, R E (1986).
"A new approach to the maximum flow problem".
\emph{Proceedings of the eighteenth annual ACM symposium on Theory of computing – STOC '86}. p. 136.
\doi{10.1145/12130.12144}

Valente, Thomas, and Rebecca Davis. 1999.
"Accelerating the Diffusion of Innovations Using Opinion Leaders",
\emph{Annals of the American Academy of Political and Social Science} 566: 56-67.
}
\seealso{
Other modifications: 
\code{\link{add_nodes}()},
\code{\link{add_ties}()},
\code{\link{as}()},
\code{\link{from}},
\code{\link{miss}},
\code{\link{reformat}},
\code{\link{split}()},
\code{\link{to_levels}},
\code{\link{to_project}},
\code{\link{to_scope}}
}
\concept{modifications}
