% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_play.R
\name{learning}
\alias{learning}
\alias{play_learning}
\alias{play_segregation}
\title{Making learning models on networks}
\usage{
play_learning(.data, beliefs, steps, epsilon = 5e-04)

play_segregation(
  .data,
  attribute,
  heterophily = 0,
  who_moves = c("ordered", "random", "most_dissatisfied"),
  choice_function = c("satisficing", "optimising", "minimising"),
  steps
)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{beliefs}{A vector indicating the probabilities nodes
put on some outcome being 'true'.}

\item{steps}{The number of steps forward in learning.
By default the number of nodes in the network.}

\item{epsilon}{The maximum difference in beliefs accepted
for convergence to a consensus.}

\item{attribute}{A string naming some nodal attribute in the network.
Currently only tested for binary attributes.}

\item{heterophily}{A score ranging between -1 and 1 as a threshold for
how heterophilous nodes will accept their neighbours to be.
A single proportion means this threshold is shared by all nodes,
but it can also be a vector the same length of the nodes in the network
for issuing different thresholds to different nodes.
By default this is 0, meaning nodes will be dissatisfied if more than half
of their neighbours differ on the given attribute.}

\item{who_moves}{One of the following options:
"ordered" (the default) checks each node in turn for whether they are
dissatisfied and there is an available space that they can move to,
"random" will check a node at random,
and "most_dissatisfied" will check (one of) the most dissatisfied nodes first.}

\item{choice_function}{One of the following options:
"satisficing" (the default) will move the node to any coordinates that satisfy
their heterophily threshold,
"optimising" will move the node to coordinates that are most homophilous,
and "minimising" distance will move the node to the next nearest unoccupied coordinates.}
}
\description{
These functions allow learning games to be played upon networks.
\itemize{
\item \code{play_learning()} plays a DeGroot learning model upon a network.
\item \code{play_segregation()} plays a Schelling segregation model upon a network.
}
}
\examples{
  play_learning(ison_networkers, 
      rbinom(manynet::network_nodes(ison_networkers),1,prob = 0.25))
  startValues <- rbinom(100,1,prob = 0.5)
  startValues[sample(seq_len(100), round(100*0.2))] <- NA
  latticeEg <- create_lattice(100)
  latticeEg <- add_node_attribute(latticeEg, "startValues", startValues)
  latticeEg
  play_segregation(latticeEg, "startValues", 0.5)
  # autographr(latticeEg, node_color = "startValues", node_size = 5) + 
  # autographr(play_segregation(latticeEg, "startValues", 0.2), 
  #            node_color = "startValues", node_size = 5)
}
\seealso{
Other makes: 
\code{\link{create}},
\code{\link{generate}},
\code{\link{play}},
\code{\link{read}},
\code{\link{write}()}

Other models: 
\code{\link{play}}
}
\concept{makes}
\concept{models}
