% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_ties.R
\name{mark_tie_select}
\alias{mark_tie_select}
\alias{tie_is_random}
\alias{tie_is_max}
\alias{tie_is_min}
\title{Marking ties for selection based on measures}
\usage{
tie_is_random(.data, size = 1)

tie_is_max(tie_measure)

tie_is_min(tie_measure)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{size}{The number of nodes to select (as TRUE).}

\item{tie_measure}{An object created by a \code{tie_} measure.}
}
\description{
These functions return logical vectors the length of the ties in a network:
\itemize{
\item \code{tie_is_random()} marks one or more ties at random.
\item \code{tie_is_max()} and \code{tie_is_min()} are more useful
for converting the results from some tie measure into a mark-class object.
They can be particularly useful for highlighting which tie or ties
are key because they minimise or, more often, maximise some measure.
}
}
\examples{
# tie_is_max(migraph::tie_betweenness(ison_brandes))
#tie_is_min(migraph::tie_betweenness(ison_brandes))
}
\seealso{
Other marks: 
\code{\link{mark_diff}},
\code{\link{mark_nodes}},
\code{\link{mark_select}},
\code{\link{mark_ties}}
}
\concept{marks}
