% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip_nodes.R
\name{manip_nodes}
\alias{manip_nodes}
\alias{add_nodes}
\alias{delete_nodes}
\alias{add_node_attribute}
\alias{mutate_nodes}
\alias{mutate}
\alias{bind_node_attributes}
\alias{join_nodes}
\alias{rename_nodes}
\alias{rename}
\alias{filter_nodes}
\title{Modifying node data}
\usage{
add_nodes(.data, nodes, attribute = NULL)

delete_nodes(.data, nodes)

add_node_attribute(.data, attr_name, vector)

mutate_nodes(.data, ...)

mutate(.data, ...)

bind_node_attributes(.data, object2)

join_nodes(
  .data,
  object2,
  .by = NULL,
  join_type = c("full", "left", "right", "inner")
)

rename_nodes(.data, ...)

rename(.data, ...)

filter_nodes(.data, ..., .by)
}
\arguments{
\item{.data}{An object of a manynet-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{nodes}{The number of nodes to be added.}

\item{attribute}{A named list to be added as tie or node attributes.}

\item{attr_name}{Name of the new attribute in the resulting object.}

\item{vector}{A vector of values for the new attribute.}

\item{...}{Additional arguments.}

\item{object2}{A second object to copy nodes or ties from.}

\item{.by}{An attribute name to join objects by.
By default, NULL.}

\item{join_type}{A type of join to be used.
Options are "full","left", "right", "inner".}
}
\value{
A data object of the same class as the function was given.
}
\description{
These functions allow users to add and delete nodes and their attributes:
\itemize{
\item \code{add_nodes()} adds an additional number of nodes to network data.
\item \code{delete_nodes()} deletes nodes from network data.
\item \code{add_node_attribute()}, \code{mutate()}, or \code{mutate_nodes()} offer ways to add
a vector of values to a network as a nodal attribute.
\item \code{rename_nodes()} and \code{rename()} rename nodal attributes.
\item \code{bind_node_attributes()} appends all nodal attributes from one network to another,
and \code{join_nodes()} merges all nodal attributes from one network to another.
\item \code{filter_nodes()} subsets nodes based on some nodal attribute-related logical statement.
}

Note that while \verb{add_*()}/\verb{delete_*()} functions operate similarly as comparable \code{{igraph}} functions,
\verb{mutate*()}, \verb{bind*()}, etc work like \code{{tidyverse}} or \code{{dplyr}}-style functions.
}
\details{
Not all functions have methods available for all object classes.
Below are the currently implemented S3 methods:\tabular{lrrr}{
    \tab igraph \tab network \tab tbl_graph \cr
   add_nodes \tab 1 \tab 1 \tab 1 \cr
   delete_nodes \tab 1 \tab 1 \tab 1 \cr
}
}
\examples{
  other <- create_filled(4) \%>\% mutate(name = c("A", "B", "C", "D"))
  add_nodes(other, 4, list(name = c("Matthew", "Mark", "Luke", "Tim")))
  other <- create_filled(4) \%>\% mutate(name = c("A", "B", "C", "D"))
  another <- create_filled(3) \%>\% mutate(name = c("E", "F", "G"))
  join_nodes(another, other)
}
\seealso{
Other modifications: 
\code{\link{manip_as}},
\code{\link{manip_correlation}},
\code{\link{manip_from}},
\code{\link{manip_levels}},
\code{\link{manip_miss}},
\code{\link{manip_paths}},
\code{\link{manip_permutation}},
\code{\link{manip_project}},
\code{\link{manip_reformat}},
\code{\link{manip_scope}},
\code{\link{manip_split}},
\code{\link{manip_ties}}
}
\concept{modifications}
