% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{ison_monks}
\alias{ison_monks}
\title{Multiplex network of three one-mode signed, weighted networks and a three-wave longitudinal network of monks (Sampson 1969)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # Sampson's Monks -----------------------------------------------------------
#> # A longitudinal, labelled, multiplex, signed, weighted, directed network of 18
#> nodes and 463 like, esteem, influence, and praise arcs over 3 waves
#> 
#> -- Nodes
#> # A tibble: 18 x 3
#>   name        groups        left
#>   <chr>       <chr>        <dbl>
#> 1 Romuald     Interstitial     3
#> 2 Bonaventure Loyal            4
#> 3 Ambrose     Loyal            4
#> 4 Berthold    Loyal            4
#> 5 Peter       Loyal            3
#> 6 Louis       Loyal            4
#> # i 12 more rows
#> 
#> -- Ties
#> # A tibble: 463 x 6
#>    from    to  sign type  weight  wave
#>   <int> <int> <dbl> <chr>  <dbl> <dbl>
#> 1     1     2     1 like       1     2
#> 2     1     2     1 like       1     3
#> 3     1     3     1 like       1     3
#> 4     1     5     1 like       3     1
#> 5     1     5     1 like       3     2
#> 6     1     5     1 like       3     3
#> # i 457 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(ison_monks)
}
\description{
The data were collected for an ethnographic study of community structure in a New England monastery.
Various sociometric data was collected of the novices attending the minor seminary of 'Cloisterville'
preparing to join the monastic order.
\itemize{
\item \code{type = "like"} records whom novices said they liked most at three time points/waves
\item \code{type = "esteem"} records whom novices said they held in esteem (sign > 0) and disesteem (sign < 0)
\item \code{type = "praise"} records whom novices said they praised (sign > 0) and blamed (sign < 0)
\item \code{type = "influence"} records whom novices said were a positive influence (sign > 0) and negative influence (sign < 0)
}

All networks are weighted.
Novices' first choices are weighted 3, the second 2, and third choices 1.
Some subjects offered tied ranks for their top four choices.

In addition to node names,
a 'groups' variable records the four groups that Sampson observed during his time there:
\itemize{
\item The \emph{Loyal} Opposition consists of novices who entered the monastery first and defended existing practices
\item The \emph{Young Turks} arrived later during a period of change and questioned practices in the monastery
\item The \emph{Interstitial} did not take sides in the debate
\item The \emph{Outcasts} were novices that were not accepted in the group
}

Information about senior monks was not included.
While \code{type = "like"} is observed over three waves,
the rest of the data was recorded retrospectively from the end of the study,
after the network fragmented.
The waves in which the novitiates were expelled (1), voluntarily departed (2 and 3),
or remained (4) are given in the nodal attribute "left".
}
\references{
Sampson, Samuel F. 1969. \emph{Crisis in a cloister}.
Unpublished doctoral dissertation, Cornell University.

Breiger R., Boorman S. and Arabie P. 1975.
"An algorithm for clustering relational data with applications to social network analysis and comparison with multidimensional scaling".
\emph{Journal of Mathematical Psychology}, 12: 328-383.
}
\keyword{datasets}
