% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_gridmap.R
\name{esp_get_gridmap}
\alias{esp_get_gridmap}
\alias{esp_get_hex_prov}
\alias{esp_get_hex_ccaa}
\alias{esp_get_grid_prov}
\alias{esp_get_grid_ccaa}
\title{Get an hexbin or a map of squares of Spain}
\usage{
esp_get_hex_prov(prov = NULL)

esp_get_hex_ccaa(ccaa = NULL)

esp_get_grid_prov(prov = NULL)

esp_get_grid_ccaa(ccaa = NULL)
}
\arguments{
\item{prov}{See \link{esp_get_prov}}

\item{ccaa}{See \link{esp_get_ccaa}}
}
\value{
A \code{POLYGON} object.
}
\description{
Loads a hexbin map (\code{sf} object) or a map of squares
with the boundaries of the provinces or autonomous communities of Spain.
}
\details{
Hexbin or grid map has an advantage over usual choropleth maps.
In choropleths, a large polygon data looks more emphasized just because
of its size, what introduces a bias. Here with hexbin, each region is
represented equally dismissing the bias.

Results are provided in \strong{EPSG:4258}, use \link[sf]{st_transform} 
to change the projection.
}
\examples{
library(sf)
library(cartography)

esp <- st_transform(esp_get_country(), 3857)

hexccaa <- st_transform(esp_get_hex_ccaa(), 3857)

plot_sf(hexccaa)
plot(st_geometry(esp),
     col = "grey80",
     border = NA,
     add = TRUE)
plot(st_geometry(hexccaa),
     col = hcl.colors(19, alpha = 0.5),
     add = TRUE)
labelLayer(hexccaa, txt = "label")



hexprov <- st_transform(esp_get_hex_prov(), 3857)

plot_sf(hexprov)
plot(st_geometry(esp),
     col = "grey80",
     border = NA,
     add = TRUE)
plot(st_geometry(hexprov),
     col = hcl.colors(19, alpha = 0.5),
     add = TRUE)
labelLayer(hexprov, txt = "label")



gridccaa <- st_transform(esp_get_grid_ccaa(), 3857)

plot_sf(gridccaa)
plot(st_geometry(esp),
     col = "grey80",
     border = NA,
     add = TRUE)
plot(st_geometry(gridccaa),
     col = hcl.colors(19, alpha = 0.5),
     add = TRUE)
labelLayer(gridccaa, txt = "label")

gridprov <- st_transform(esp_get_grid_prov(), 3857)

plot_sf(gridprov)
plot(st_geometry(esp),
     col = "grey80",
     border = NA,
     add = TRUE)
plot(st_geometry(gridprov),
     col = hcl.colors(19, alpha = 0.5),
     add = TRUE)
labelLayer(gridprov, txt = "label")
}
\seealso{
\link{esp_get_nuts}, \link{esp_get_ccaa}, \link{esp_get_prov},
\link{esp_get_munic}, \link{esp_codelist}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
