% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_rivers.R
\name{esp_get_rivers}
\alias{esp_get_rivers}
\title{Get rivers, channels, reservoirs and other wetlands of Spain}
\source{
IGN data via a custom CDN (see
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata}.
}
\usage{
esp_get_rivers(
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "3",
  spatialtype = "line",
  name = NULL
)
}
\arguments{
\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
\code{.geojson} file.}

\item{cache_dir}{A path to a cache directory. See Details.}

\item{verbose}{Display information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the polygon. Values available are "3", "6.5"
or "10".}

\item{spatialtype}{Spatial type of the output. Use "area" for \code{POLYGONS} or
"line" for \code{LINESTRING}.}

\item{name}{Optional. A character or regex expresion with the name of the
element to be extracted. See Details}
}
\value{
A \code{POLYGON} or \code{LINESTRING} object.
}
\description{
Loads a simple feature (\code{sf}) object containing lines or
areas with the required hydrograpic elements of Spain.
}
\details{
Metadata available on
\url{https://github.com/rOpenSpain/mapSpain/tree/sianedata/}.

\code{name} admits regex expressions. See \code{help("regex", package = "base")}
for more information.
}
\examples{
\donttest{
# This code would produce a nice plot - It will take a few seconds to run
library(sf)

# Use of regex

regex1 <- esp_get_rivers(name = "Tajo|Segura")
unique(regex1$rotulo)

regex2 <- esp_get_rivers(name = "Tajo$| Segura")
unique(regex2$rotulo)

# Rivers in Spain
shapeEsp <- esp_get_country(moveCAN = FALSE)

MainRivers <-
  esp_get_rivers(name = "Tajo$|Ebro$|Ebre$|Duero|Guadiana$|Guadalquivir")

opar <- par(no.readonly = TRUE)
par(mar = c(0, 0, 0, 0))

plot(st_geometry(MainRivers), col = "skyblue", lwd = 1.5)
plot(st_geometry(shapeEsp), col = NA, add = TRUE)

# All wetlands

Wetlands <- esp_get_rivers(spatialtype = "area")
plot(st_geometry(Wetlands), col = "skyblue", border = NA)
plot(st_geometry(shapeEsp), col = NA, add = TRUE)

par(opar)
}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{natural}
