% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{esp_munic.sf}
\alias{esp_munic.sf}
\title{All Municipalities \code{POLYGON} object of Spain}
\format{
A \code{POLYGON} data frame (resolution: 1:1million, EPSG:4258) object:
\itemize{
\item codauto: INE code of each autonomous community.
\item ine.ccaa.name: INE name of each autonomous community.
\item cpro: INE code of each province.
\item ine.prov.name: INE name of each province.
\item cmun: INE code of each municipality.
\item name: Name of the municipality.
\item LAU_CODE: LAU Code (GISCO) of the municipality.
\item geometry: geometry field.
}
}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/}, LAU 2019
data.
}
\description{
A \code{sf} object including all municipalities of Spain as provided by GISCO
(2019 version).
}
\examples{
library(sf)

data("esp_munic.sf")
data("esp_nuts.sf")

Teruel.cpro <- esp_dict_region_code("Teruel", destination = "cpro")
Teruel.NUTS <- esp_dict_region_code(Teruel.cpro,
  origin = "cpro",
  destination = "nuts"
)

Teruel.sf <- esp_munic.sf[esp_munic.sf$cpro == Teruel.cpro, ]
Teruel.city <- Teruel.sf[Teruel.sf$name == "Teruel", ]

NUTS <-
  esp_nuts.sf[esp_nuts.sf$LEVL_CODE == 3 &
    esp_nuts.sf$NUTS_ID != Teruel.NUTS, ]


plot(st_geometry(Teruel.sf), col = "cornsilk")
plot(st_geometry(Teruel.city), col = "firebrick3", add = TRUE)
plot(st_geometry(NUTS), col = "wheat", add = TRUE)
title(main = "Municipalities of Teruel", line = 1)
}
\seealso{
\code{\link[=esp_get_munic]{esp_get_munic()}}
}
\concept{datasets}
