% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_country.R
\name{esp_get_country}
\alias{esp_get_country}
\title{Get boundaries of Spain}
\usage{
esp_get_country(...)
}
\arguments{
\item{...}{Additional parameters from \code{\link[=esp_get_nuts]{esp_get_nuts()}}.}
}
\value{
A \code{MULTIPOLYGON/MULTIPOINT} object.
}
\description{
Loads a single \code{sf} object containing the boundaries of Spain.
}
\examples{

library(sf)

OriginalCan <- esp_get_country(moveCAN = FALSE)

plot(OriginalCan$geometry, col = hcl.colors(5))

MovedCan <- esp_get_country(moveCAN = TRUE)

plot(MovedCan$geometry, col = hcl.colors(5))
}
\seealso{
\code{\link[=esp_get_nuts]{esp_get_nuts()}}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{political}
