% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp_get_nuts.R
\name{esp_get_nuts}
\alias{esp_get_nuts}
\title{Get NUTS of Spain as \code{sf} polygons and points}
\source{
\href{https://gisco-services.ec.europa.eu/distribution/v2/}{GISCO API}
}
\usage{
esp_get_nuts(
  year = "2016",
  epsg = "4258",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  resolution = "01",
  spatialtype = "RG",
  region = NULL,
  nuts_level = "all",
  moveCAN = TRUE
)
}
\arguments{
\item{year}{Release year of the file. One of \code{"2003"}, \code{"2006"},
\code{"2010"}, \code{"2013"}, \code{"2016"}  or \code{"2021"}.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item \code{"4258"}: ETRS89
\item \code{"4326"}: WGS84
\item \code{"3035"}: ETRS89 / ETRS-LAEA
\item \code{"3857"}: Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the geospatial data. One of
\itemize{
\item "60": 1:60million
\item "20": 1:20million
\item "10": 1:10million
\item "03": 1:3million
\item "01": 1:1million
}}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \code{"LB"}: Labels - point object.
\item \code{"RG"}: Regions - polygon object.
}}

\item{region}{Optional. A vector of region names, NUTS or ISO codes
(see \code{\link[=esp_dict_region_code]{esp_dict_region_code()}}).}

\item{nuts_level}{NUTS level. One of "0" (Country-level), "1", "2" or "3".
See \strong{Description}.}

\item{moveCAN}{A logical \code{TRUE/FALSE} or a vector of coordinates
\code{c(lat, lon)}. It places the Canary Islands close to Spain's mainland.
Initial position can be adjusted using the vector of coordinates. See
\strong{Displacing the Canary Islands}.}
}
\value{
A \code{sf} object specified by \code{spatialtype}.
}
\description{
Returns
\href{https://en.wikipedia.org/wiki/NUTS_statistical_regions_of_Spain}{NUTS regions of Spain}
as polygons and points at a specified scale, as provided by
\href{https://ec.europa.eu/eurostat/web/gisco}{GISCO}
(Geographic Information System of the Commission, depending of Eurostat).

NUTS are provided at three different levels:
\itemize{
\item \strong{"0"}: Country level
\item \strong{"1"}: Groups of autonomous communities
\item \strong{"2"}: Autonomous communities
\item \strong{"3"}: Roughly matches the provinces, but providing specific individual
objects for each major island
}
}
\note{
Please check the download and usage provisions on
\code{\link[giscoR:gisco_attributions]{giscoR::gisco_attributions()}}
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.
}

\section{Displacing the Canary Islands}{
While \code{moveCAN} is useful for visualization, it would alter the actual
geographic position of the Canary Islands. When using the output for
spatial analysis or using tiles (e.g. with \code{\link[=esp_getTiles]{esp_getTiles()}} or
\code{\link[=addProviderEspTiles]{addProviderEspTiles()}})  this option should be set to \code{FALSE} in order to
get the actual coordinates, instead of the modified ones.
}

\examples{

NUTS1 <- esp_get_nuts(nuts_level = 1, moveCAN = TRUE)

library(ggplot2)

ggplot(NUTS1) +
  geom_sf() +
  labs(
    title = "NUTS1: Displacing Canary Islands",
    caption = giscoR::gisco_attributions()
  )


NUTS1_alt <- esp_get_nuts(nuts_level = 1, moveCAN = c(15, 0))


ggplot(NUTS1_alt) +
  geom_sf() +
  labs(
    title = "NUTS1: Displacing Canary Islands",
    subtitle = "to the right",
    caption = giscoR::gisco_attributions()
  )


NUTS1_orig <- esp_get_nuts(nuts_level = 1, moveCAN = FALSE)

ggplot(NUTS1_orig) +
  geom_sf() +
  labs(
    title = "NUTS1",
    subtitle = "Canary Islands on the true location",
    caption = giscoR::gisco_attributions()
  )


AndOriental <-
  esp_get_nuts(region = c("Almeria", "Granada", "Jaen", "Malaga"))


ggplot(AndOriental) +
  geom_sf()



RandomRegions <- esp_get_nuts(region = c("ES1", "ES300", "ES51"))

ggplot(RandomRegions) +
  geom_sf() +
  labs(title = "Random Regions")


MixingCodes <- esp_get_nuts(region = c("ES4", "ES-PV", "Valencia"))


ggplot(MixingCodes) +
  geom_sf() +
  labs(title = "Mixing Codes")
}
\seealso{
\code{\link[giscoR:gisco_get_nuts]{giscoR::gisco_get_nuts()}}, \code{\link[=esp_dict_region_code]{esp_dict_region_code()}}.

Other political: 
\code{\link{esp_codelist}},
\code{\link{esp_get_can_box}()},
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_country}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_prov}()}

Other nuts: 
\code{\link{esp_nuts.sf}}
}
\concept{nuts}
\concept{political}
