% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{do_mapbayr_sim}
\alias{do_mapbayr_sim}
\title{Simulate with mapbayr}
\usage{
do_mapbayr_sim(
  x,
  data,
  recsort = 3,
  output = "df",
  ...,
  eta = NULL,
  nrep = NULL,
  new_omega = NULL,
  new_sigma = NULL
)
}
\arguments{
\item{x}{the model object}

\item{data}{NMTRAN-like data set}

\item{recsort}{record sorting flag. Defaulted to 3. See \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.}

\item{output}{type of object returned. Defaulted to \code{"df"} for a data.frame. See \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.}

\item{...}{passed to \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.}

\item{eta}{a matrix of individual point estimates of ETA. Most likely obtained with \code{\link[=get_eta]{get_eta()}}.}

\item{nrep}{number of replicates. If used, the original "ID" in the data will be replaced by unique identifiers.}

\item{new_omega, new_sigma}{New "omega" and "sigma" matrices to use instead of those defined in "$OMEGA" and "$SIGMA".}
}
\value{
An output from \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}}.
}
\description{
A wrapper around \code{\link[mrgsolve:mrgsim]{mrgsolve::mrgsim()}} for results generated from \code{\link[=mapbayest]{mapbayest()}}. Exported for the purpose of utility but might be prone to changes.
}
\examples{
library(mrgsolve)
mod <- exmodel(1, exdata = FALSE)
dat <- exdata(ID = c(1,2))

# Classic framework
set.seed(123)
do_mapbayr_sim(x = mod, data = dat, Request = "DV")

# No random effect
do_mapbayr_sim(x = zero_re(mod), data = dat)
do_mapbayr_sim(x = mod, data = dat, new_omega = "zero_re")

# New random effects
## New omega matrix
do_mapbayr_sim(x = mod, data = dat, new_omega = dmat(0.1, 0.03, 0.01), nrep = 10)

## Matrix with "eta" as mean and "new_omega" as variance covariance matrix
etamat <- get_eta(est001, output = "num")[1:2,]

do_mapbayr_sim(
  x = mod, data = dat, nrep = 10,
  eta = etamat, new_omega = dmat(0.1, 0.03, 0.01)
)

}
