% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R
\name{mb_isochrone}
\alias{mb_isochrone}
\title{Generate isochrones using the Mapbox Navigation Service Isochrone API}
\usage{
mb_isochrone(
  location,
  profile = "driving",
  time = c(5, 10, 15),
  distance = NULL,
  depart_at = NULL,
  access_token = NULL,
  denoise = 1,
  generalize = NULL,
  geometry = "polygon",
  output = "sf",
  rate_limit = 300,
  keep_color_cols = FALSE,
  id_column = NULL
)
}
\arguments{
\item{location}{A vector of form \code{c(longitude, latitude)}, an address that can be geocoded as a character string, or an \code{sf} object.}

\item{profile}{One of "driving", "walking", "cycling", or "driving-traffic".
"driving" is the default.}

\item{time}{A vector of isochrone contours, specified in minutes. Defaults to \code{c(5, 10, 15)}. The maximum time supported is 60 minutes. Reflects traffic conditions for the date and time at which the function is called. If reproducibility of isochrones is required, supply an argument to the \code{depart_at} parameter.}

\item{distance}{A vector of distance contours specified in meters. If supplied, will supercede
any call to the \code{time} parameter as time and distance cannot be used
simultaneously. Defaults to \code{NULL}.}

\item{depart_at}{(optional) For the "driving" or "driving-traffic" profiles, the departure date and time to reflect historical traffic patterns. If "driving-traffic" is used, live traffic will be mixed in with historical traffic for dates/times near to the current time. Should be specified as an ISO 8601 date/time, e.g. \code{"2022-03-31T09:00"}. If \code{NULL} (the default), isochrones will reflect traffic conditions at the date and time when the function is called.}

\item{access_token}{A valid Mapbox access token.}

\item{denoise}{A floating-point value between 0 and 1 used to remove smaller contours. 1 is the default and returns only the largest contour for an input time.}

\item{generalize}{A value expressed in meters of the tolerance for the Douglas-Peucker generalization algorithm used to simplify the isochrone shapes. If \code{NULL} (the default), the Mapbox API will choose an optimal value for you.}

\item{geometry}{one of \code{"polygon"} (the default), which returns isochrones as polygons, or alternatively \code{"linestring"}, which returns isochrones as linestrings.}

\item{output}{one of \code{"sf"} (the default), which returns an \code{sf} object representing the isochrone(s), or \code{"list"}, which returns the GeoJSON response from the API as an R list.}

\item{rate_limit}{The rate limit for the API, expressed in maximum number of calls per minute. For most users this will be 300 though this parameter can be modified based on your Mapbox plan. Used when \code{location} is \code{"sf"}.}

\item{keep_color_cols}{Whether or not to retain the color columns that the Mapbox API generates by default (applies when the output is an \code{sf} object). Defaults to \code{FALSE}.}

\item{id_column}{If the input dataset is an \code{sf} object, the column in your dataset you want to use as the isochrone ID. Otherwise, isochrone IDs will be identified by row index or position.}
}
\value{
An \code{sf} object representing the isochrone(s) around the location(s).
}
\description{
This function returns isochrones from the Mapbox Navigation Service
\href{https://docs.mapbox.com/api/navigation/isochrone/}{Isochrone API}. Isochrones are
shapes that represent the reachable area around one or more locations within
a given travel time. Isochrones can be computed for driving, walking, or
cycling routing profiles, and can optionally be set to return distances
rather than times. \code{\link[=mb_isochrone]{mb_isochrone()}} returns isochrones as simple
features objects in the WGS 1984 geographic coordinate system.
}
\examples{
\dontrun{

library(mapboxapi)
library(mapdeck)
isochrones <- mb_isochrone("The Kremlin, Moscow Russia",
  time = c(4, 8, 12),
  profile = "walking"
)

mapdeck(style = mapdeck_style("light")) \%>\%
  add_polygon(
    data = isochrones,
    fill_colour = "time",
    fill_opacity = 0.5,
    legend = TRUE
  )
}

}
