% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layer_path.R
\name{add_path}
\alias{add_path}
\title{Add Path}
\usage{
add_path(
  map,
  data = get_map_data(map),
  polyline = NULL,
  stroke_colour = NULL,
  stroke_width = NULL,
  stroke_opacity = NULL,
  dash_size = NULL,
  dash_gap = NULL,
  offset = NULL,
  width_units = c("meters", "pixels"),
  width_min_pixels = NULL,
  width_max_pixels = NULL,
  width_scale = 1,
  tooltip = NULL,
  billboard = FALSE,
  layer_id = NULL,
  id = NULL,
  auto_highlight = FALSE,
  highlight_colour = "#AAFFFFFF",
  palette = "viridis",
  na_colour = "#808080FF",
  legend = FALSE,
  legend_options = NULL,
  legend_format = NULL,
  update_view = TRUE,
  focus_layer = FALSE,
  digits = 6,
  transitions = NULL,
  brush_radius = NULL
)
}
\arguments{
\item{map}{a mapdeck map object}

\item{data}{data to be used in the layer. All coordinates are expected to be
EPSG:4326 (WGS 84) coordinate system}

\item{polyline}{optional column of \code{data} containing the polylines, if using encoded polylines}

\item{stroke_colour}{variable of \code{data} or hex colour for the stroke. If used,
\code{elevation} is ignored.
If using a hex colour, use either a single value, or a column of hex colours  on \code{data}}

\item{stroke_width}{width of the stroke in meters. Default 1.}

\item{stroke_opacity}{Either a string specifying the column of \code{data}
containing the opacity of each shape, or a single value in [0,255], or [0, 1),
to be applied to all the shapes. Default 255. If a hex-string is used as the
colour, this argument is ignored and you should include the alpha on the hex string}

\item{dash_size}{size of each dash, relative to the width of the stroke}

\item{dash_gap}{size of the gap between dashes, relative to the width of the stroke}

\item{offset}{The offset to draw each path with, relative to the width of the path.
Negative offset is to the left hand side, and positive offset is to the right hand side.
0 extrudes the path so that it is centered at the specified coordinates.}

\item{width_units}{The units of the line width, one of 'meters', 'pixels'.
When zooming in and out, meter sizes scale with the base map, and pixel sizes
remain the same on screen.}

\item{width_min_pixels}{The minimum path width in pixels.
This can be used to prevent the path from getting too thin when zoomed out.}

\item{width_max_pixels}{The maximum path width in pixels.
his prop can be used to prevent the path from getting too thick when zoomed in.}

\item{width_scale}{The path width multiplier that multiplied to all paths.}

\item{tooltip}{variable of \code{data} containing text or HTML to render as a tooltip}

\item{billboard}{logical indicating if the path always faces the camera (TRUE) or
if it always faces up (FALSE)}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers of the same type. Layers with the same id are likely
to conflict and not plot correctly}

\item{id}{an id value in \code{data} to identify layers when interacting in Shiny apps.}

\item{auto_highlight}{logical indicating if the shape under the mouse should auto-highlight}

\item{highlight_colour}{hex string colour to use for highlighting. Must contain the alpha component.}

\item{palette}{string or matrix. String will be one of \code{colourvalues::colour_palettes()}.
A matrix must have at least 5 rows, and 3 or 4 columns of values between [0, 255],
where the 4th column represents the alpha. You can use a named list to specify a different
palette for different colour options (where available),
 e.g. list(fill_colour = "viridis", stroke_colour = "inferno")}

\item{na_colour}{hex string colour to use for NA values}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{legend_format}{A list containing functions to apply to legend values. See section legend}

\item{update_view}{logical indicating if the map should update the bounds to include this layer}

\item{focus_layer}{logical indicating if the map should update the bounds to only include this layer}

\item{digits}{number of digits for rounding coordinates}

\item{transitions}{list specifying the duration of transitions.}

\item{brush_radius}{radius of the brush in metres. Default NULL. If supplied,
the arcs will only show if the origin or destination are within the radius of the mouse.
If NULL, all arcs are displayed}
}
\description{
The Path Layer takes in lists of coordinate points and renders them as
extruded lines with mitering.
}
\details{
\code{add_path} supports LINESTRING and MULTILINESTRING sf objects
}
\section{transitions}{


The transitions argument lets you specify the time it will take for the shapes to transition
from one state to the next. Only works in an interactive environment (Shiny)
and on WebGL-2 supported browsers and hardware.

The time is in milliseconds

Available transitions for path

list(
path = 0,
stroke_colour = 0,
stroke_width = 0
)
}

\section{data}{


If the \code{data} is a simple feature object, the geometry column is automatically
detected. If the sf object contains more than one geometry column and you want to use a specific one,
you'll need to set the active geometry using \code{sf::st_geometry( x ) <- "your_column" },
where \code{"your_column"} is the name of the column you're activating. See \code{?sf::st_geometry}
}

\section{legend}{


The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
  \item{digits - number to round the legend values to}
}

If the layer allows different fill and stroke colours, you can use different options for each. See examples in \link{add_arc}.

The \code{legend_format} can be used to control the format of the values in the legend.
This should be a named list, where the names are one of
\itemize{
  \item{fill_colour}
  \item{stroke_colour}
}

depending on which type of colouring the layer supports.

The list elements must be functions to apply to the values in the legend.
}

\section{id}{


The \code{id} is returned to your R session from an interactive shiny environment
by observing layer clicks. This is useful for returning the data.frame row relating to the
cliked shape.

From within a shiny server you would typically use \code{ observeEvent({input$map_arc_click})},
where 'map' is the map_id supplied to \code{mapdeckOutput()}, and 'arc' is the layer
you are clicking on
}

\examples{
\donttest{

## You need a valid access token from Mapbox
key <- 'abc'
set_token( key )

mapdeck(
  style = mapdeck_style("dark")
  , location = c(145, -37.8)
  , zoom = 10) \%>\%
  add_path(
    data = roads
    , stroke_colour = "RIGHT_LOC"
    , layer_id = "path_layer"
    , tooltip = "ROAD_NAME"
    , auto_highlight = TRUE
    , legend = T
  )
}

}
