% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_maps.R
\name{read_maps}
\alias{read_maps}
\title{Read genetic maps}
\usage{
read_maps(mapfiles = NULL, sep = NULL, header = TRUE, na.strings = "NA",
  type = c("delim", "JoinMap"), mapweights = NULL)
}
\arguments{
\item{mapfiles}{List of filenames to read}

\item{sep}{The field separator character, see read.delim}

\item{header}{A logical value indicating whether the files contains the names of variable int the first line, see read.delim()}

\item{na.strings}{How to interpret missing values? See read.delim()}

\item{type}{Type of input data, either delimited file with columns "Marker", "LG", and "Position" or a JoinMap ".map" file.}

\item{mapweights}{numeric vector mapweights}
}
\value{
A mapfuser object with the genetic maps listed under the raw_data slot. Chromosome identifiers are added to the config slot
}
\description{
Reads genetic maps in either delimited or JoinMap format. Maps are loaded to a mapfuser object.
}
\examples{
fpath <- system.file("extdata", package="mapfuser")
maps <- list.files(fpath, pattern = "Col", full.names = TRUE)
MF.obj <- read_maps(mapfiles = maps, sep = ",", header = TRUE,
mapweights = rep(1,7), type = "delim")
}
\author{
Dennis van Muijen
}
