% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickview.R
\name{maplibre_view}
\alias{maplibre_view}
\title{Quick visualization of geometries with MapLibre GL}
\usage{
maplibre_view(
  data,
  column = NULL,
  n = NULL,
  style = carto_style("positron"),
  ...
)
}
\arguments{
\item{data}{An sf object to visualize}

\item{column}{The name of the column to visualize. If NULL (default), geometries are shown with default styling.}

\item{n}{Number of quantile breaks for numeric columns. If specified, uses step_expr() instead of interpolate().}

\item{style}{The MapLibre style to use. Defaults to carto_style("positron").}

\item{...}{Additional arguments passed to maplibre()}
}
\value{
A MapLibre GL map object
}
\description{
This function provides a quick way to visualize sf geometries using MapLibre GL JS.
It automatically detects the geometry type and applies appropriate styling.
}
\examples{
\dontrun{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf"))

# Basic view
maplibre_view(nc)

# View with column visualization
maplibre_view(nc, column = "AREA")

# View with quantile breaks
maplibre_view(nc, column = "AREA", n = 5)
}
}
