% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPI_CheckData.R
\name{MAPI_CheckData}
\alias{MAPI_CheckData}
\title{Function MAPI_CheckData}
\usage{
MAPI_CheckData(
  samples,
  metric,
  isMatrix = all((class(metric) == "matrix"), (nrow(metric) == ncol(metric)))
)
}
\arguments{
\item{samples}{a data.frame with names and geographical coordinates of samples. Column names must be: 'ind', 'x', 'y'.
Optional column 'errRad' with an error radius for sample locations (eg. GPS uncertainty). Coordinates must be projected (not latitude/longitude).}

\item{metric}{a data.frame or a square matrix with the pairwise metric computed for all pairs of samples.
If data.frame, column names must be: 'ind1', 'ind2', 'value'.  If matrix, sample names must be the row- and column names.}

\item{isMatrix}{Boolean. Depends on the 'metric' data:\cr
TRUE if 'metric' is a square matrix with column names = row names and standing for sample names.\cr
FALSE if 'metric is a three columns data.frame ('ind1', 'ind2', 'value'). \cr
The default value is determined using a "matrix" class detection for 'metric' as well as identity between row and column number.}
}
\value{
a list of two data.table objects corresponding to 'samples' and 'metric' after cleaning.
}
\description{
Check the validity of the 'samples' and 'metric' data loaded.\cr
Missing data are removed from 'metric', samples with missing coordinates are removed and samples that are not present in both dataset ('samples' and 'metric') are discarded.
}
\examples{
\dontrun{
data("samples")
data("metric")
# remove first sample in order to force warning
samples <- samples[-c(1) , ]
clean.list <- MAPI_CheckData(samples, metric)
checked.samples <- clean.list[['samples']]
checked.metric <- clean.list[['metric']]
}

}
