% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAPI_Plot.R
\name{MAPI_Plot}
\alias{MAPI_Plot}
\title{Function MAPI_Plot}
\usage{
MAPI_Plot(
  resu,
  tails = NULL,
  samples = NULL,
  pal = c("#994000", "#CC5800", "#FF8F33", "#FFAD66", "#FFCA99", "#FFE6CC", "#FBFBFB",
    "#CCFDFF", "#99F8FF", "#66F0FF", "#33E4FF", "#00AACC", "#007A99"),
  shades = 20,
  main = NA,
  upper = TRUE,
  lower = TRUE,
  upper.border = "black",
  lower.border = "gray"
)
}
\arguments{
\item{resu}{A spatial object of class 'sf' resulting from a MAPI analysis done using
\code{\link{MAPI_RunAuto}} or \code{\link{MAPI_RunOnGrid}}.}

\item{tails}{An optional spatial object of class 'sf' resulting from the post-process with
\code{\link{MAPI_Tails}} of a MAPI analysis result. Default = NULL (no tails shown).}

\item{samples}{A data.frame with names and geographical coordinates of samples.
Column names must be: 'ind', 'x', 'y'.
Optional column 'errRad' with an error radius for sample locations (eg. GPS uncertainty).
Coordinates must be projected (not latitude/longitude).}

\item{pal}{A color ramp, eg. from \pkg{RColorBrewer} (default: orange > light gray > blue)}

\item{shades}{Number of breaks for the color ramp (default 20)}

\item{main}{Plot title (none by default)}

\item{upper}{If TRUE and tails is not NULL, upper-tail significant areas are plotted. TRUE by default.}

\item{lower}{If TRUE and tails is not NULL, lower-tail significant areas are plotted. TRUE by default.}

\item{upper.border}{Border color of the upper-tail significant area. "black" by default.}

\item{lower.border}{Border color of the lower-tail significant area. "gray" by default.}
}
\value{
Returns the "trellis" object.
}
\description{
Plot a MAPI analysis result
}
\examples{
\dontrun{
data("metric")
data("samples")
resu <- MAPI_RunAuto(samples, metric, crs=3857, nbPermuts = 1000)
tails <- MAPI_Tails(resu)
pl <- MAPI_Plot(resu, tails=tails, samples=samples)
# Open png driver
png("mapiPlotOutput.png", width=1000, type="cairo-png")
print(pl) # Do plot in file
dev.off() # Close driver
}
}
