% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_data_transformation.R
\name{merge_coords_data}
\alias{merge_coords_data}
\title{Merge coordinates and admixture data}
\usage{
merge_coords_data(coord_df, admix_df)
}
\arguments{
\item{coord_df}{a data.frame of site names and coordinates.}

\item{admix_df}{a data.frame of site names and admixture data.}
}
\value{
\code{data.frame}
}
\description{
Internal function used to join coordinates and admixture pie data.
}
\examples{
# Admixture Format 1
df_admix <- data.frame(
  Site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  Cluster1 = c(0.95, 0.5, 0.1, 0, 0),
  Cluster2 = c(0.05, 0.45, 0.45, 0.01, 0.75),
  Cluster3 = c(0, 0.05, 0.45, 0.99, 0.25)
)

# Coordinates Format
df_coords <- data.frame(
  Site = c("London", "Paris", "Berlin", "Rome", "Madrid"),
  Lat = c(51.51, 48.85, 52.52, 41.90, 40.42),
  Lon = c(-0.12, 2.35, 13.40, 12.49, -3.70)
)

merge_coords_data(df_coords, df_admix)
}
\keyword{internal}
