% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dist_prob_to_class}
\alias{dist_prob_to_class}
\title{Returns the class with the highest probability in 
a genotype probability distribution}
\usage{
dist_prob_to_class(geno, prob.thres = 0.9)
}
\arguments{
\item{geno}{the probabilistic genotypes contained in the object
\code{'mappoly.data'}}

\item{prob.thres}{probability threshold to select the genotype. 
Values below this genotype are assumed as missing data}
}
\value{
a matrix containing the doses of each genotype and
    marker. Markers are disposed in rows and individuals are 
    disposed in columns. Missing data are represented by NAs
}
\description{
Returns the class with the highest probability in 
a genotype probability distribution
}
\examples{
\donttest{
geno.dose <- dist_prob_to_class(hexafake.geno.dist$geno)
geno.dose$geno.dose[1:10,1:10]
}   
}
\keyword{internal}
