% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_matrix.R
\name{google_matrix}
\alias{google_matrix}
\title{Get distance matrix from the Google Maps Distance Matrix API}
\usage{
google_matrix(origins, destinations, mode = c("driving", "transit", "walking",
  "bicycling"), alternatives = FALSE, key = NULL)
}
\arguments{
\item{origins}{Origins, as numeric vector of length two (lon, lat)}

\item{destinations}{Destinations, as numeric vector of length two (lon, lat)}

\item{mode}{Travel mode, one of: "driving", "transit", "walking", "bicycling"}

\item{alternatives}{Whether to return more than one alternative (\code{logical})}

\item{key}{Google APIs key (optional)}
}
\value{
XML document with Google Maps Distance Matrix API response
}
\description{
Get distance matrix from the Google Maps Distance Matrix API
}
\examples{
library(xml2)
doc = as_xml_document(response_matrix)
\dontrun{
doc = google_matrix(
  origins = rbind(c(34.81127, 31.89277), c(35.212085, 31.769976)),
  destinations = c(34.781107, 32.085003)
)
locations = c("Haifa", "Tel-Aviv", "Jerusalem", "Beer-Sheva")
doc = google_matrix(
  origins = locations,
  destinations = locations
)
}
}
