% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_matrix.R
\name{mp_matrix}
\alias{mp_matrix}
\title{Get distance matrix from the Google Maps Distance Matrix API}
\usage{
mp_matrix(
  origins,
  destinations,
  mode = c("driving", "transit", "walking", "bicycling"),
  arrival_time = NULL,
  departure_time = NULL,
  avoid = NULL,
  region = NULL,
  key,
  quiet = FALSE
)
}
\arguments{
\item{origins}{Origins, as \itemize{
\item{\code{character} vector with addresses to be geocoded}
\item{\code{numeric} vector of length two (lon, lat)}
\item{\code{matrix} with two columns (lon, lat)}
\item{\code{sf} or \code{sfc} point layer}
}}

\item{destinations}{Destinations, in one of the same formats as for \code{origins}}

\item{mode}{Travel mode, one of: \code{"driving"}, \code{"transit"}, \code{"walking"}, \code{"bicycling"}}

\item{arrival_time}{The desired time of arrival for transit directions, as \code{POSIXct}}

\item{departure_time}{The desired time of departure, as \code{POSIXct}}

\item{avoid}{\code{NULL} (default) or one of: \code{"tolls"}, \code{"highways"}, \code{"ferries"} or \code{"indoor"}}

\item{region}{The region code, specified as a ccTLD ("top-level domain") two-character value (e.g. \code{"es"} for Spain) (optional)}

\item{key}{Google APIs key}

\item{quiet}{Logical; suppress printing URL for Google Maps API call (e.g. to hide API key)}
}
\value{
XML document with Google Maps Distance Matrix API response
}
\description{
Get distance matrix from the Google Maps Distance Matrix API
}
\note{
Use function \code{\link{mp_get_matrix}} to extract \strong{distance} and \strong{duration} \code{matrix} objects
}
\examples{
# Built-in reponse example
library(xml2)
doc = as_xml_document(response_matrix)

\dontrun{

# Using 'data.frame' input
doc = mp_matrix(
  origins = rbind(c(34.81127, 31.89277), c(35.212085, 31.769976)),
  destinations = c(34.781107, 32.085003)
)

# Using 'character' input
locations = c("Haifa", "Tel-Aviv", "Jerusalem", "Beer-Sheva")
doc = mp_matrix(
  origins = locations,
  destinations = locations
)
}
}
\references{
\url{https://developers.google.com/maps/documentation/distance-matrix/intro}
}
