% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewExtent.R
\name{viewExtent}
\alias{addExtent}
\alias{viewExtent}
\alias{viewExtent,addExtent}
\title{View extent/bbox of spatial objects interactively}
\usage{
viewExtent(x, map = NULL, map.types = mapviewGetOption("basemaps"),
  popup = NULL, ...)

addExtent(x, map, popup, ...)
}
\arguments{
\item{x}{either a Raster* object or a Spatial* object}

\item{map}{a leaflet map the extent should be added to. If NULL
standard background layers are cretaed}

\item{map.types}{the map types to be used in case map is NULL}

\item{popup}{a character vector of the HTML content for the popups. See
\code{\link{addControl}} for details.}

\item{...}{additional arguments passed on to \code{\link{addRectangles}}}
}
\description{
This function produces an interactive view of the extent/bbox
of the supplied spatial object
}
\section{Functions}{
\itemize{
\item \code{addExtent}: add extent/bbox of spatial objects interactively
}}
\examples{
\dontrun{
### raster data ###
library(sp)
library(raster)

data(meuse.grid)
coordinates(meuse.grid) = ~x+y
proj4string(meuse.grid) <- CRS("+init=epsg:28992")
gridded(meuse.grid) = TRUE

viewExtent(meuse.grid)
}

}
\author{
Tim Appelhans
}

