% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapshot.R
\name{mapshot}
\alias{mapshot}
\alias{mapshot2}
\title{Save mapview or leaflet map as HTML and/or image using webshot}
\usage{
mapshot(
  x,
  url = NULL,
  file = NULL,
  remove_controls = c("zoomControl", "layersControl", "homeButton", "scaleBar",
    "drawToolbar", "easyButton"),
  ...
)

mapshot2(
  x,
  url = NULL,
  file = NULL,
  remove_controls = c("zoomControl", "layersControl", "homeButton", "scaleBar",
    "drawToolbar", "easyButton", "control"),
  ...
)
}
\arguments{
\item{x}{\code{mapview} or \code{leaflet} object (or any other hmtlwidget).}

\item{url}{Output \code{.html} file. If not supplied and 'file' is specified,
a temporary index file will be created.}

\item{file}{Output \code{.png}, \code{.pdf}, or \code{.jpeg} file.}

\item{remove_controls}{\code{character} vector of control buttons to be removed
from the map when saving to file. Any combination of
\code{"zoomControl"}, \code{"layersControl"}, \code{"homeButton"}, \code{"scaleBar"}, \code{"drawToolbar"},
\code{"easyButton"}. If set to \code{NULL} nothing will be removed. Ignored if \code{x}
is not a mapview or leaflet map.}

\item{...}{Further arguments passed on to \code{\link[htmlwidgets]{saveWidget}}
and/or \code{\link[webshot2]{webshot}}.}
}
\description{
Save a mapview or leaflet map as \code{.html} index file or \code{.png},
\code{.pdf}, or \code{.jpeg} image.
}
\details{
mapshot uses \code{\link[webshot]{webshot}} from the webshot package.
mapshot2 uses \code{\link[webshot2]{webshot}} from the webshot2 package.

mapshot can be used to save both leaflet and mapview maps as html or png
files or both. In theory, it should also work for any and all other htmlwidgets
but has not been tested extensively for other htmlwidgets.

In case you want to save larger maps mapshot is likely to fail. You can try
setting \code{selfcontained = FALSE} to avoid errors and create a valid
local html file.

mapshot2 uses \code{\link[htmlwidgets]{saveWidget}} and \code{\link[webshot2]{webshot}}
to save maps as \code{.html} and/or \code{.png|.jpg} files, respectively.
\code{\link[webshot2]{webshot}} assumes a findable installation of some Chrome
browser variant on your system. If you see the the following error:

\code{
  `google-chrome` and `chromium-browser` were not found.
  Try setting the CHROMOTE_CHROME environment variable or adding one of these
  executables to your PATH.
}

it means that \code{\link[chromote]{find_chrome}} cannot find a Chrome based
browser in your system. Please see
\url{https://github.com/rstudio/chromote#specifying-which-browser-to-use}
for more details.
}
\section{Functions}{
\itemize{
\item \code{mapshot()}: Save mapview or leaflet map as HTML and/or image using webshot

\item \code{mapshot2()}: Save mapview or leaflet map as HTML and/or image using webshot2

}}
\examples{
\dontrun{
  library(utils)

  m = mapview(breweries)
  html_fl = tempfile(fileext = ".html")
  png_fl = tempfile(fileext = ".png")

  ## create standalone .html
  mapshot(m, url = html_fl)
  browseURL(html_fl)

  ## create standalone .png; temporary .html is removed automatically unless
  ## 'remove_url = FALSE' is specified
  mapshot(m, file = png_fl)
  browseURL(png_fl)
  mapshot(m, file = png_fl,
          remove_controls = c("homeButton", "layersControl"))
  browseURL(png_fl)

  ## create .html and .png
  mapshot(m, url = html_fl, file = png_fl)
  browseURL(png_fl)
  browseURL(html_fl)
}

\dontrun{
  library(utils)

  m = mapview(breweries)
  html_fl = tempfile(fileext = ".html")
  png_fl = tempfile(fileext = ".png")

  ## create standalone .html
  mapshot2(m, url = html_fl)
  browseURL(html_fl)

  ## create standalone .png; temporary .html is removed automatically unless
  ## 'remove_url = FALSE' is specified
  mapshot2(m, file = png_fl)
  browseURL(png_fl)
  mapshot2(m, file = png_fl,
           remove_controls = c("homeButton", "layersControl"))
  browseURL(png_fl)

  ## create .html and .png
  mapshot2(m, url = html_fl, file = png_fl)
  browseURL(png_fl)
  browseURL(html_fl)
}

}
\seealso{
\code{\link[webshot]{webshot}}, \code{\link[htmlwidgets]{saveWidget}}.

\code{\link[webshot2]{webshot}}.
}
