% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapviewOptions.R
\name{mapviewOptions}
\alias{mapviewOptions}
\alias{mapviewGetOption}
\title{Global options for the mapview package}
\usage{
mapviewOptions(platform, basemaps, raster.size, mapview.maxpixels,
  plainview.maxpixels, maxpoints, maxpolygons, maxlines, raster.palette,
  vector.palette, verbose, na.color, legend, legend.pos,
  layers.control.pos, default = FALSE, console = TRUE, leafletWidth,
  leafletHeight)

mapviewGetOption(param)
}
\arguments{
\item{platform}{character. The platform to be used.
Current options are "leaflet" and "quickmapr".}

\item{basemaps}{character. The basemaps to be used for rendering data. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for possible
values}

\item{raster.size}{numeric. see the maxBytes argument in \code{\link{addRasterImage}}}

\item{mapview.maxpixels}{numeric. The maximum amount of pixels allowed for Raster*
objects to be rendered with \code{mapview}. Defaults to 500000.
Set this higher if you have a potent machine or are patient enough to wait a little.}

\item{plainview.maxpixels}{numeric. The maximum amount of pixels allowed for Raster*
objects to be rendered with \code{plainview}. Defaults to 10000000.
Set this higher if you have a potent machine or are patient enough to wait a little.}

\item{maxpoints}{numeric. Maximum number of points allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{maxpolygons}{numeric. Maximum number of polygons allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{maxlines}{numeric. Maximum number of lines allowed for leaflet overlay
rendering. If this number is exceeded rendering will be done
using special functionality which will provide much more speed and better handling.
This means that standard functionality is reduced.
For example adding layers via "+" is not possible anymore.}

\item{raster.palette}{a color palette function for raster visualisation.
Should be a function that takes an integer as input and returns a vector of colors.
See \code{\link{colorRampPalette}} for details.}

\item{vector.palette}{a color palette function for vector visualisation.
Should be a function that takes an integer as input and returns a vector of colors.
See \code{\link{colorRampPalette}} for details.}

\item{verbose}{logical. Many functions in mapview provide details about their
behaviour. Set this to TRUE if you want to see these printed to the console.}

\item{na.color}{character. The default color to be used for NA values.}

\item{legend}{logical. Whether or not to show a legend for the layer(s).}

\item{legend.pos}{Where should the legend be placed?
One of "topleft", "topright", "bottomleft", "bottomright".}

\item{layers.control.pos}{character. Where should the layer control be
placed? One of "topleft", "topright", "bottomleft", "bottomright".}

\item{default}{logical. If TRUE all options are set to their default values}

\item{console}{logical. Should the options be printed to the console}

\item{leafletWidth, leafletHeight}{height and width of the htmlwidget in px.}

\item{param}{character. parameter to be queried.}
}
\value{
list of the current options (invisibly).
If no arguments are provided the options are printed.
}
\description{
To permanently set any of these options, you can add them to
<your R installation>/etc/Rprofile.site>. For example,
to change the default number of pixels to be visualised for Raster* objects,
add a line like this: options(mapviewMaxPixels = 700000) to that file.
}
\section{Functions}{
\itemize{
\item \code{mapviewGetOption}: query single mapviewOption parameters
}}

\examples{
mapviewOptions()
mapviewOptions(na.color = "pink")
mapviewOptions()

mapviewGetOption("platform")

mapviewOptions(default = TRUE)
mapviewOptions()


}
\seealso{
\code{\link{rasterOptions}}, \code{\link{options}}
}
\author{
Tim Appelhans
}
