% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/march.indep.R
\name{march.indep.construct}
\alias{march.indep.construct}
\title{Construct an independence model (zero-order Markov chain).}
\usage{
march.indep.construct(y, maxOrder = 0)
}
\arguments{
\item{y}{the \code{\link[=march.Dataset-class]{Dataset for march package}} from which construct the model.}

\item{maxOrder}{the maximum visible order among the set of Markovian models to compare.}
}
\value{
The \code{\link{march.Indep-class}} constructed using dataset y and maxOrder.
}
\description{
Construct a \code{\link[=march.Indep-class]{independence model}} from a given \code{\link[=march.Dataset-class]{march.Dataset}},
the first \emph{maxOrder} elements of each sequence being truncated in order to return a model
which can be compared with other Markovian models of visible order maxOrder.
}
\examples{
# Build an independance model from the pewee data set.
model <- march.indep.construct(pewee)
print(model)
}
\author{
Ogier Maitre
}
\seealso{
\code{\link{march.Indep-class}}, \code{\link{march.Model-class}}, \code{\link{march.Dataset-class}}.
}

