% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy.comparisons}
\alias{tidy.comparisons}
\title{Tidy a \code{comparisons} object}
\usage{
\method{tidy}{comparisons}(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{An object produced by the \code{comparisons} function.}

\item{conf.int}{Logical indicating whether or not to include a confidence interval.}

\item{conf.level}{The confidence level to use for the confidence interval if
\code{conf.int=TRUE}. Must be strictly greater than 0 and less than 1. Defaults
to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments are passed to the \code{predict()} method used to
compute adjusted predictions. These arguments are particularly useful for
mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} document for a non-exhaustive list of available
arguments.}
}
\value{
A "tidy" \code{data.frame} of summary statistics which conforms to the
\code{broom} package specification.
}
\description{
Calculate average contrasts by taking the mean of all the
unit-level contrasts computed by the \code{predictions} function.
}
\examples{
mod <- lm(mpg ~ factor(gear), data = mtcars)
contr <- comparisons(mod, contrast_factor = "sequential")
tidy(contr)
}
