% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allBiodiversity.R
\name{allBiodiversity}
\alias{allBiodiversity}
\title{Calculates all Biodiversity indicators}
\usage{
allBiodiversity(X, metric = "ABUNDANCE", groups = "ALL",
  species.table = NULL, TL.table, percentiles = c(0.25, 0.75),
  minTL = 0, years, raw = TRUE, std = TRUE, glob.env = TRUE,
  export.path = NULL, export.id = NULL)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID},
\code{SPECIES}, and \code{ABUNDANCE}. \code{YEAR} indicates the year the
observation was recorded, \code{ID} is an area code indicating where the
observation was recorded, \code{SPECIES} is a numeric code indicating the
species sampled, and \code{ABUNDANCE} is the corresponding abundance
(stratified and corrected for catchability as required).}

\item{metric}{A character string indicating which column in \code{X} to use to
calculate the indicators. Default is \code{metric = "ABUNDANCE"}.}

\item{groups}{A vector indicating the species group(s) for which to calculate
the indicators. If \code{groups = "ALL"}, all species will be included;
otherwise, each entry must be a character string matching the name of a
column in \code{species.table}. Default is \code{groups = "ALL"}.}

\item{species.table}{A table where the column names match the entries in
\code{groups}. Column entries are species codes indicating the species from
\code{X} included in each group. \code{species.table} may also include
columns for other species groups; these will be ignored. If \code{groups =
"ALL"}, this table is not required. Default is \code{species.table = NULL}.}

\item{TL.table}{A dataframe with columns \code{SPECIES} and the corresponding
\code{TL} (trophic level). Entries in the \code{SPECIES} column should be
the unique values of species codes in \code{X} (or a subset thereof). Other
columns in \code{TL.table} are ignored. If \code{TL.table = NULL}, Kempton's
Q will not be calculated.}

\item{percentiles}{The percentiles used to determine R1 and R2 for calculating
Kempton's Q. Default is \code{percentiles = c(0.25, 0.75)}.}

\item{minTL}{Minimum trophic level for species included to calculate Kempton's
Q. Default is \code{minTL = 0}.}

\item{years}{A vector of years for which to calculate indicators.}

\item{raw}{A logical value. If \code{raw = TRUE}, the raw indicator values are
returned by the function. If \code{raw = FALSE}, the raw indicator values are
not returned. Default is \code{raw = TRUE}. Either \code{raw} or \code{std}
must be \code{TRUE}.}

\item{std}{A logical value. If \code{std = TRUE}, the standardized indicator
values for each area \code{ID} are returned by the function. Indicators are
standardized using z-scores, i.e., by subtracting the mean and dividing by
the standard deviation (ignoring \code{NA} values). If \code{std = FALSE},
the standardized indicator values are not returned. Default is \code{std =
TRUE}. Either \code{raw} or \code{std} must be \code{TRUE}.}

\item{glob.env}{Logical value indicating whether to return output to global
environment. Default is \code{glob.env = TRUE}.}

\item{export.path}{File path indicating where to save a .csv file of
calculated indicators (named biodiversity_export.id.csv; see below). If
\code{export.file = NULL}, the indicator dataframe will not be exported as a
.csv file. Default is \code{export.path = NULL}.}

\item{export.id}{Character string to modify the name of the .csv file (if
export.path is specified), for example an area name or date of analysis. The
exported .csv file is named biodiversity_export.id.csv. Default is
\code{export.id = NULL}.}
}
\value{
Returns a dataframe with columns \code{ID}, \code{YEAR}, and
 indicators corresponding to the arguments supplied to the function.
 Standardized indicators are noted with \code{_s} in the name.
}
\description{
This function calculates all (or a subset) of the Biodiversity
 indicators for \eqn{j} areas and \eqn{i} years. The user can choose whether
 the function returns the indicator dataframe to the global environment,
 exports the dataframe to a csv file, or both. The user can also choose
 whether the function returns the raw indicator values, the standardized
 (z-score) values, or both.
}
\details{
This function calculates the Biodiversity indicators: Species
 Richness, Shannon's Index of Diversity, Margalef's Species Richness,
 Pielou's Species Evenness, Hill's N1, Hill's N2, Heip's Evenness Index, and
 Kempton's Q. If trophic level data are not available to calculate Kempton's
 Q, the remaining Biodiversity indicators will be returned. See the help file
 for the individual functions for information on how each indicator is
 calculated.

 Notes on indicator calculations: In the individual functions, the user
 generally has control over which metric (e.g., \code{"BIOMASS"} or
 \code{"ABUNDANCE"}) and group (e.g., \code{"ALL"} or \code{"GROUNDFISH"})
 are used to calculate the indicator. Here, the same metric and group are
 used to calculate each indicator. Defaults are \code{metric = "ABUNDANCE"}
 and \code{group = "ALL"}.
}
\examples{
data(X)

# Calculate raw and standardized indicators
allBiodiversity(X = X, metric = "ABUNDANCE", groups = "ALL", TL.table = species.info,
   percentiles = c(.25, 0.75), minTL = 0, years = c(2014:2019), raw = TRUE, std = TRUE)
}
\seealso{
Other biodiversity indicators: \code{\link{heips}},
  \code{\link{hillN1}}, \code{\link{hillN2}},
  \code{\link{kemptonQ}}, \code{\link{margalef}},
  \code{\link{pielouEvenness}}, \code{\link{shannon}},
  \code{\link{speciesRichness}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{biodiversity indicators}
