% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{get_fold_data}
\alias{get_fold_data}
\title{Get fold data}
\usage{
get_fold_data(species, fold_type, k)
}
\arguments{
\item{species}{dataframe or character vector. Row from the dataframe returned
by \code{\link{list_species}} or the name of the species.}

\item{fold_type}{character. Type of partitioning you want to use, default is
\code{"disc"}.}

\item{k}{integer vector. Numbers of the folds you want to get data for, if
you want all folds use \code{1:5}, which is the default.}
}
\value{
A 5 element list with fold data filled in for all \code{k}. Fold data
  consists of a list with 4 elements: \code{occurrence_training},
  \code{occurrence_test}, \code{background_training} and
  \code{background_test}.
}
\description{
\code{get_fold_data} returns a list of training and test occurrence and
background data fold(s) for one or more species.
}
\details{
The different \code{fold_type} are:

  \code{"disc"}: 5-fold disc partitioning of occurrences with pairwise
  distance sampled and buffer filtered random background points, equivalent
  to calling \code{\link{kfold_occurrence_background}} with
  \code{occurrence_fold_type = "disc", k = 5, pwd_sample = TRUE,
  background_buffer = 200*1000}

  \code{"grid_4"} and \code{"grid_9"}: 4-fold and 9-fold grid partitioning of
  occurrences with pairwise distance sampled and buffer filtered random
  background points, equivalent to calling
  \code{\link{kfold_occurrence_background}} with \code{occurrence_fold_type =
  "grid", k = 4, pwd_sample = TRUE, background_buffer = 200*1000}

  \code{"random"}: 5-fold random partitioning of occurrences and random
  background points, equivalent to calling
  \code{\link{kfold_occurrence_background}} with \code{occurrence_fold_type =
  "random", k = 5, pwd_sample = FALSE, background_buffer = 0}

  \code{"targetgroup"}: same way of partitioning as the \code{"random"} folds
  but instead of random background points, a random subset of all occurrences
  points was used creating a targetgroup background points set which has the
  same sampling bias as the entire dataset.
}
\examples{
\dontrun{
aba_folds <- get_fold_data("Abalistes stellatus", "random", k = 1:5)
k1 <- aba_folds[[1]]
k1$occurrence_training
k1$occurrence_test
k1$background_training
k1$background_test
}
}
\seealso{
\code{\link{list_species}} \code{\link{lapply_kfold_species}}
  \code{\link{lapply_species}} \code{\link{kfold_data}}
}

