% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframes.R
\name{list2df}
\alias{list2df}
\title{List to data.frame}
\usage{
list2df(x, name = "name", value = "value", show_NA, warn = TRUE)
}
\arguments{
\item{x}{A (preferably) named \code{list} with any number of values}

\item{name, value}{Names of the new key and value columns, respectively}

\item{show_NA}{Ignored; if set will trigger a warning}

\item{warn}{Logical; if TRUE will show a warning when}
}
\value{
a \code{data.frame} object with columns \code{"name"} and \code{"value"} for the
names of the \code{list} and the values in each
}
\description{
Converts a list object into a data.frame
}
\details{
Unlike \code{base::list2DF()}, \code{list2df()} tries to format the data.frame by using
the names of the list as values rather than variables.  This creates a
longer form list that may be more tidy.
}
\examples{
x <- list(a = 1, b = 2:4, c = letters[10:20], "unnamed", "unnamed2")
list2df(x, "col1", "col2", warn = FALSE)

# contrast with `base::list2DF()`
if (packageVersion("base") >= as.package_version('4.0')) {
  list2DF(x)
}
}
