% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bib.R
\name{read_bib}
\alias{read_bib}
\title{Read Bib file}
\usage{
read_bib(file, skip = 0L, max_lines = NULL, encoding = "UTF-8")
}
\arguments{
\item{file}{File or connection}

\item{skip}{The lines to skip}

\item{max_lines}{The maximum number of lines to read}

\item{encoding}{Assumed encoding of file (passed to readLines)}
}
\value{
A \code{data.frame} with each row as a bib entry and each column as a
field
}
\description{
Read a bib file into a data.frame
}
\details{
Inspired and partially credited to \code{bib2df::bib2df()} although this has no
dependencies outside of base functions and much quicker.  This speed seems
to come from removing \code{stringr} functions and simplifying a few *apply
functions.
This will also include as many categories as possible from the entry.
}
\examples{
file <- "https://raw.githubusercontent.com/jmbarbone/bib-references/master/references.bib"
bibdf <- read_bib(file, max_lines = 51L)

if (package_available("tibble")) {
  tibble::as_tibble(bibdf)
} else {
  head(bibdf)
}

if (package_available("bib2df") & package_available("bench")) {
  file <- system.file("extdata", "bib2df_testfile_3.bib", package = "bib2df")

  # Doesn't include the 'tidying' up
  foo <- function(file) {
    bib <- ("bib2df" \%colons\% "bib2df_read")(file)
    ("bib2df" \%colons\% "bib2df_gather")(bib)
  }

\donttest{
  bench::mark(
    read_bib = read_bib(file),
    bib2df = bib2df::bib2df(file),
    foo = foo(file),
    check = FALSE
  )[1:9]
}
}
}
\seealso{
\code{\link[bib2df:bib2df]{bib2df::bib2df()}}
}
